#Script to make conservation figures with all iORFs 
library(RColorBrewer)


ccol=c("springgreen3","seagreen","salmon1", "purple3", "mediumpurple1","midnightblue"
)

#Read tables 

#presence absence matrix one line per orf
datacons=read.table("../tables_out/02conservation/conservation_table_spar.txt",colClasses=c(
"character","character","character","numeric", "character",rep("numeric",8)))

#orf infos per haplo : one line per orf per haplo
dataorf=read.table("../tables_out/02conservation/orf_table_spar.txt")

#######################################################################
#counts 
#######################################################################
#select orf presents (statut=1)
data1=dataorf[dataorf$statut=="1",]
dim(data1) #total
table(data1$haplo) #orf number per haplo


#number of ORF without redundancy and without ancestral lost ORFs
table_count=table(datacons$group[datacons$group != '7_ancest'])
table_count

round(table_count/sum(table_count)*100, digit=0)


#######################################################################
# Figures 
#######################################################################
#Image conservation
#=======================================================================
nbhaplo=26
#On ordonne differement fixed et polymorphic 
#without ancestral sequences
data_a=datacons[datacons$group !="7_ancest",]
datasort=data_a[order(data_a$group, data_a$cons, decreasing=T),]

tsort=matrix(as.numeric(unlist(strsplit(as.character(datasort$cons),""))), ncol=nbhaplo, byrow=T)

#On change les couleurs
tcol=NULL
for (i in 1:dim(tsort)[2]){
	haploi=tsort[,i]
	coli=datasort$col
	haploi[haploi==1]=coli[haploi==1]+1
	haploi[haploi==0]=1
	tcol=cbind(tcol, haploi)
	
}

#tiff("../figures/02conservation/Figure1_ORF_conservation.tiff", width = 1500, height = 1000, units = "px")

cairo_ps("../figures/02conservation/Figure1_ORF_conservation.pdf", width = 15, height =10)

	image(tcol, col=c("white",ccol), axes=FALSE)
	grid(NA, 26, lty=1, lwd=1)
	box(which = "plot")

dev.off()
