#!/usr/bin/env python

import os
from subprocess import Popen, PIPE

#Rename to run historian to corres with phylogeny names 
dir_sid="../../02synt_intergenic_fasta/01_aligned_4/"
dir_rename="../../02synt_intergenic_fasta/01_aligned_4_rename/"

list_sid=os.popen("ls "+dir_sid).read().rstrip().split("\n")


for fasta_sid in list_sid:
    #print fasta_sid
    
    #test empt file 
    testfile=os.stat(dir_sid+fasta_sid).st_size <= 5
    
    if testfile == False:
        #print fasta_sid
        fasta_re=fasta_sid.replace("fasta", "rename.fasta")
        with open(dir_sid+fasta_sid) as fasta:
            with open(dir_rename+fasta_re,"w") as out:
                for line in fasta:
                    line=line.rstrip()
                    if line.startswith(">"):
                        newline= line.replace(">","").split(";")[1]
                        out.write(">"+newline+"\n")
                    else:
                        out.write(line+"\n")

#Run historian #########################################################
#link to tree obtained with phyml on intergenic regions
dir_tree="../../10_ancestral_rec/00_make_phylogenyHC/01_resultsPhyML/hc4_intergenic_phy_phyml/hc4_tree.txt"
dir_results="../../02synt_intergenic_fasta/02_historian_results/"


list_re=os.popen("ls "+dir_rename).read().rstrip().split("\n")

for fasta_sid in list_re:
    print fasta_sid
    
    file_results=fasta_sid.replace("aligned4.rename.fasta","recons.fasta")
    
    #Run historian 
    cmd=" historian recon -preset jc -ancseq \
    -output fasta -guide "+dir_rename+fasta_sid+" -tree "+dir_tree+" > "+dir_results+file_results
    
    os.system(cmd)

