#!/usr/bin/env python

import os
import re

#Script to prepare files to run synchro


#====================================================================
#==BEGIN FUNCTIONS=====================================================
#====================================================================

def august_prot(file_in):
    """from an augustus output : return a dictionnary with prot sequences """
    
    init=0  #Variable pour rester dans le même groupe de gènes
    dico_prot ={}
    with open(file_in ) as filei: 
        for line in filei:
            line=line.rstrip()
            m1=re.match(r"^#\s{1}start\sgene\s(g\d+)", line)
            m2=re.match(r"^#\s{1}protein\ssequence\s=\s\[(\w+)", line)
            m3=re.match(r"^#\s{1}end\s{1}gene",line)
            m4=re.match(r"^#\s{1}(\w+)\]?", line)
            #On recupere l identifiant 
            if m1 is not None: 
                geneid=m1.group(1)
            #On reinitialise si fin du gene
            if m3 is not None:
                init=0
            #Si premiere ligne dico
            if m2 is not None:
                init=1
                dico_prot[geneid]= m2.group(1)
            #Sinon on ajoute a la suite dans le dico
            elif init==1 and m4 is not None:
                dico_prot[geneid]=dico_prot[geneid]+m4.group(1)
    return dico_prot


def august_nuc(file_in):
    """from an augustus output : return a dictionnary with coding nucl sequences """
    
    init=0  #Variable pour rester dans le même groupe de gènes
    dico_prot ={}
    with open(file_in ) as filei: 
        for line in filei:
            line=line.rstrip()
            m1=re.match(r"^#\s{1}start\sgene\s(g\d+)", line)
            m2=re.match(r"^#\s{1}coding\ssequence\s=\s\[(\w+)", line)
            m3=re.match(r"^#\s{1}protein\ssequence\s=\s\[(\w+)", line)
            m4=re.match(r"^#\s{1}(\w+)\]?", line)
            #On recupere l identifiant 
            if m1 is not None: 
                geneid=m1.group(1)
            #On reinitialise si fin du gene
            if m3 is not None:
                init=0
            #Si premiere ligne dico
            if m2 is not None:
                init=1
                dico_prot[geneid]= m2.group(1)
            #Sinon on ajoute a la suite dans le dico
            elif init==1 and m4 is not None:
                dico_prot[geneid]=dico_prot[geneid]+m4.group(1)
    return dico_prot



#====================================================================
#==END FUNCTIONS=====================================================
#====================================================================



#====================================================================
#==BEGIN ANALYSIS====================================================
#====================================================================

dir_augustus="../../01annot_gene/01augustus_pseudoscaff/"
#take liste of file names for augustus output
liste_file=os.popen("ls "+dir_augustus+"*").read().rstrip().split("\n")
#directory for fasta output 
dir_out="../../01annot_gene/02fasta_all/fasta_prot/"

for file_in in liste_file:
    file_in=file_in.rstrip()
    #print file_in
    #On recupere les sequences prot dans un dictionnaire
    dico_prot=august_prot(file_in)
    
    libname=file_in.split("/")[-1].split(".")[0]
    #out_def=libname+".def"
    out_prt=libname+"_AA.fasta"
    
    #Return a dictionnary with prot sequences in a dictionnary 
    
    
    #Préparation du fichier fasta avec infos de positions pour synchro
    with open(file_in) as filei:
        with open(dir_out+out_prt,"w") as outprt:
            #outdef.write("\t".join(cnames)+"\n")
            for line in filei:
                line=line.rstrip()
                m=re.match(r"^#", line)
                if m is None:
                    array=line.split("\t")
                    if array[2]=="gene":
                        type="gene"
                        name=array[8]
                        #chrom=int(array[0].split("_")[1])
                        chrom=array[0]
                        start=int(array[3])
                        end=int(array[4])
                        strand=array[6]
                        sens="t"
                        cline=[type, name, str(chrom), str(start), \
                        str(end), strand, sens]
                        pline="\t".join(cline)
                        outprt.write(">"+pline+"\n")
                        seq_lines="\n".join(re.findall(r".{1,60}", \
                        dico_prot[name]))+"\n"
                        outprt.write(seq_lines)

#idem with dna 
dir_out2="../../01annot_gene/02fasta_all/fasta_nuc_coding/"

for file_in in liste_file:
    file_in=file_in.rstrip()
    #print file_in
    #On recupere les sequences prot dans un dictionnaire
    dico_prot=august_nuc(file_in)
    
    libname=file_in.split("/")[-1].split(".")[0]
    #out_def=libname+".def"
    out_prt=libname+"_DNA_coding.fasta"
    
    #Return a dictionnary with prot sequences in a dictionnary 
    
    
    #Préparation du fichier fasta avec infos de positions pour synchro
    with open(file_in) as filei:
        with open(dir_out2+out_prt,"w") as outprt:
            #outdef.write("\t".join(cnames)+"\n")
            for line in filei:
                line=line.rstrip()
                m=re.match(r"^#", line)
                if m is None:
                    array=line.split("\t")
                    if array[2]=="gene":
                        type="gene"
                        name=array[8]
                        #chrom=int(array[0].split("_")[1])
                        chrom=array[0]
                        start=int(array[3])
                        end=int(array[4])
                        strand=array[6]
                        sens="t"
                        cline=[type, name, str(chrom), str(start), \
                        str(end), strand, sens]
                        pline="\t".join(cline)
                        outprt.write(">"+pline+"\n")
                        seq_lines="\n".join(re.findall(r".{1,60}", \
                        dico_prot[name]))+"\n"
                        outprt.write(seq_lines)



