function [pep_rts,pep_intens,pep_ratio] = get_histone6(MS2_index,MS2_peaks,hno,His,pepno,delta)
%%

% select MS scan
pts = [];
snum = 0;
ndata = 5;
for i=1:ndata
    p = find( MS2_index(:,3)==pepno+(i-1)*delta );
    if 1==isempty(p)
        break;
    end
    snum = snum + 1;
    pts(1,snum) = p;%#ok
end

npep = length(hno);
pep_rts = zeros([npep,snum]);%#ok
pep_intens = zeros([npep,snum]);%#ok
if 0==snum
    pep_rts = zeros([npep,1]);
    pep_intens = zeros([npep,1]);
    pep_ratio = repmat(1/npep,[npep,1]);
    return;
end

Mods = GetMods();
instruments = MS2_index(pts,6);% MS2dirs = {'CIDIT','CIDFT','ETDIT','ETDFT','HCDIT','HCDFT'};
% ActiveType, tol
c_instrument = instruments(1);
if 3==c_instrument || 4==c_instrument
    ActiveType = 'ETD';
else
    ActiveType = 'CID';
end
if 1==mod(c_instrument,2)
    tol = 0.4;
else
    tol = 0.02;
end

% K1,K2
% K = get_key_ions(His,hno,Mods,ActiveType);
K1 = get_key_ions(His,[hno(1) hno(2)],Mods,ActiveType);
K2 = get_key_ions(His,[hno(2) hno(3)],Mods,ActiveType);
K3 = get_key_ions(His,[hno(3) hno(5)],Mods,ActiveType);
K4 = get_key_ions(His,[hno(5) hno(6)],Mods,ActiveType);
K5 = get_key_ions2(His,[hno(6) hno(3)],Mods,ActiveType);
pep_rts0 = zeros([2,snum]);
pep_intens1 = zeros([2,snum]);
pep_intens2 = zeros([2,snum]);
pep_intens3 = zeros([2,snum]);
pep_intens4 = zeros([2,snum]);
pep_intens5 = zeros([2,snum]);

num_MS2 = size(MS2_index,1);
index = [1;MS2_index(1:num_MS2,7)];
for jno=1:snum
    pno = pts(jno);
    cur_rts = MS2_index(pno,3);% MS2 scan
    
    IX = index(pno):index(pno+1)-1;
    mz = MS2_peaks(IX,1);
    inten = MS2_peaks(IX,2);
    for ino=1:2
        pep_rts0(ino,jno) = cur_rts;
        K1x = K1(ino,:);
        K1x = unique(K1x);
        for kno=1:length(K1x)
            ix1 = find(abs(mz-K1x(kno))<=tol);
            if 0==isempty(ix1)
                pep_intens1(ino,jno) = pep_intens1(ino,jno)+max(inten(ix1));
            end
        end
        
        K2x = K2(ino,:);
        K2x = unique(K2x);
        for kno=1:length(K2x)
            ix1 = find(abs(mz-K2x(kno))<=tol);
            if 0==isempty(ix1)
                pep_intens2(ino,jno) = pep_intens2(ino,jno)+max(inten(ix1));
            end
        end
        
        K3x = K3(ino,:);
        K3x = unique(K3x);
        for kno=1:length(K3x)
            ix1 = find(abs(mz-K3x(kno))<=tol);
            if 0==isempty(ix1)
                pep_intens3(ino,jno) = pep_intens3(ino,jno)+max(inten(ix1));
            end
        end
        
        K4x = K4(ino,:);
        K4x = unique(K4x);
        for kno=1:length(K4x)
            ix1 = find(abs(mz-K4x(kno))<=tol);
            if 0==isempty(ix1)
                pep_intens4(ino,jno) = pep_intens4(ino,jno)+max(inten(ix1));
            end
        end
        
        K5x = K5(ino,:);
        K5x = unique(K5x);
        for kno=1:length(K5x)
            ix1 = find(abs(mz-K5x(kno))<=tol);
            if 0==isempty(ix1)
                pep_intens5(ino,jno) = pep_intens5(ino,jno)+max(inten(ix1));
            end
        end
    end
end

% multi data points
if snum>1
    [pep_rts1,pep_intens1] = get_most_column(pep_rts0,pep_intens1);%#ok
    [pep_rts2,pep_intens2] = get_most_column(pep_rts0,pep_intens2);%#ok
    [pep_rts3,pep_intens3] = get_most_column(pep_rts0,pep_intens3);%#ok
    [pep_rts4,pep_intens4] = get_most_column(pep_rts0,pep_intens4);%#ok
    [pep_rts5,pep_intens5] = get_most_column(pep_rts0,pep_intens5);%#ok
end

if 0==sum(pep_intens1) && 0==sum(pep_intens2) && 0==sum(pep_intens3) && 0==sum(pep_intens4) && 0==sum(pep_intens5)
    pep_rts = zeros([npep,1]);
    pep_intens = zeros([npep,1]);
    pep_ratio = repmat(1/npep,[npep,1]);
else
    pep_rts = repmat(pep_rts0(1,1),[npep,1]);
    r1 = sum(pep_intens1(1))/(eps+sum(pep_intens1(1))+sum(pep_intens1(2)));
    r2 = sum(pep_intens2(1))/(eps+sum(pep_intens2(1))+sum(pep_intens2(2)));
    r3 = sum(pep_intens3(1))/(eps+sum(pep_intens3(1))+sum(pep_intens3(2)));
    r4 = sum(pep_intens4(1))/(eps+sum(pep_intens4(1))+sum(pep_intens4(2)));
    r5 = 1.1*sum(pep_intens5(1))/(eps+sum(pep_intens5(1))+sum(pep_intens5(2)));
    X = resove_linear(r1,r2,r3,r4,r5);
    pep_intens = X;
    pep_ratio = X;
end

function X = resove_linear(r1,r2,r3,r4,r5)
%%

if r2==0
    % r2=0
    a=0;
    b=0;
    d=0;
    c=r3;
    if r3>=r4
        e=0;
        f=1-r3;
    else
        e=r4-r3;
        f=1-r4;
    end
    X = [a;b;c;d;e;f];
elseif r3==0
    % r3=0
    a=0;
    b=0;
    c=0;
    d=r2;
    if r2>=r4
        e=0;
        f=1-r2;
    else
        e=r4-r2;
        f=1-r4;
    end
    X = [a;b;c;d;e;f];
elseif r4==0
    % r4=0
    a=r2;
    b=0;
    c=0;
    d=0;
    e=0;
    f=1-r2;
    X = [a;b;c;d;e;f];
elseif r1==0
    % r1=0
    a=0;
    if r3>=r4
        d=0;
        e=0;
        b=r2;
        if r2>=r3
            c=0;
        else
            c=r3-r2;
        end
        f=1-b-c;
    elseif r2>=r4
        c=0;
        e=0;
        b=r3;
        if r3>=r2
            d=0;
        else
            d=r2-r3;
        end
        f=1-b-d;
    else
        if r2>r3
            c=0;
            b=r3;
            d=r2-r3;
            e=r4-r2;
        else
            d=0;
            b=r2;
            c=r3-r2;
            e=r4-r3;
        end
        f=1-r4;
    end
    X = [a;b;c;d;e;f];
elseif r5==0
    % r5=0
    a=r1;
    f=0;
    if r1>=r2
        b=0;
        d=0;
        if r1>=r3
            c=0;
            e=1-r1;
        else
            c=r3-r1;
            e=1-r3;
        end
    elseif r1>=r3
        b=0;
        c=0;
        d=r2-r1;
        e=1-r2;
    else
        % similar to r1=0
        r2=r2-r1;
        r3=r3-r1;
        r4=1-r1;
        if r3>=r4
            d=0;
            e=0;
            b=r2;
            if a+b>=1
                b=1-a;
                c=0;
            else
                c=1-a-b;
            end
        elseif r2>=r4
            c=0;
            e=0;
            b=r3;
            if a+b>=1
                b=1-a;
                d=0;
            else
                d=1-a-b;
            end
        else
            if r2>r3
                c=0;
                b=r3;
                d=r2-r3;
                e=r4-r2;
            else
                d=0;
                b=r2;
                c=r3-r2;
                e=r4-r3;
            end
            a=1-r4;
        end
    end
    X = [a;b;c;d;e;f];
else
    % all above 0
    a=r4/(r4+1/r1-1);
    f=1-r4/(r1*r4+1-r1);
    if a+f>=1
        b=0;
        c=0;
        d=0;
        e=0;
        f=1-a;
    elseif a>=r2
        b=0;
        d=0;
        if a>=r3
            c=0;
            e=1-a-f;
        else
            c=r3-a;
            if a+f+c>=1
                c=1-a-f;
                e=0;
            else
                e=1-a-f-c;
            end
        end
    elseif a>=r3
        b=0;
        c=0;
        d=r2-a;
        if a+f+d>=1
            d=1-a-f;
            e=0;
        else
            e=1-a-f-d;
        end
    else
        % similar to r1=0
        r2=r2-a;
        r3=r3-a;
        r4=1-a-f;
        if r3>=r4
            d=0;
            e=0;
            b=r2;
            if a+f+b>=1
                b=1-a-f;
                c=0;
            else
                c=1-a-f-b;
            end
        elseif r2>=r4
            c=0;
            e=0;
            b=r3;
            if a+f+b>=1
                b=1-a-f;
                d=0;
            else
                d=1-a-f-b;
            end
        else
            if r2>r3
                c=0;
                b=r3;
                d=r2-r3;
                e=r4-r2;
            else
                d=0;
                b=r2;
                c=r3-r2;
                e=r4-r3;
            end
        end
    end
    X = [a;b;c;d;e;f];
end