function [pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,delta)
%%

% select MS scan
pts = [];
snum = 0;
ndata = 5;
for i=1:ndata
    p = find( MS1_index(:,1)==pepno+(i-1)*delta );
    if 1==isempty(p)
        break;
    end
    snum = snum + 1;
    pts(1,snum) = p;%#ok
end

npep = size(His.pep_mz,1);
pep_rts = zeros([npep,snum]);
pep_intens = zeros([npep,snum]);
if 0==snum
    pep_rts = zeros([npep,1]);
    pep_intens = zeros([npep,1]);
    return;
end

num_MS1 = size(MS1_index,1);
index = [1;MS1_index(1:num_MS1,3)];

for jno=1:snum
    % get MS1 profile
    pno = pts(jno);
    cur_rts = MS1_index(pno,1);% MS1 scan
    
    IX = index(pno):index(pno+1)-1;
    mz = MS1_peaks(IX,1);
    inten = MS1_peaks(IX,2);
    for ino=1:npep
        pep_rts(ino,jno) = cur_rts;
        c_mz = His.pep_mz(ino,1);
        c_ptol = min([ptol*c_mz*1e-6,0.3]);
        left = c_mz - c_ptol;
        right = c_mz + c_ptol;
        pos = find( mz>=left & mz<=right );
        if 0==isempty(pos)
            pep_intens(ino,jno) = max(inten(pos));
        end
    end
end

% multi data points
if snum>1
    [pep_rts,pep_intens] = get_most_column(pep_rts,pep_intens);
end