function draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens)
%%

nplot = size(His.pep_mz,1);
out_file1 = fullfile(fileparts(cur_outpath),[out_filename,'.pdf']);
warning off all;
set(gcf,'visible','off');
% set(gcf,'position',[0 0 1000 1000]);
if 1==strcmp(out_filename(1:2),'HH')
    out_filename = out_filename(2:end);
end
p = strfind(out_filename,'_');
cur_title = [out_filename(1:p(1)-1),' ',out_filename(p(2)+1:p(3)-1),'-',out_filename(p(3)+1:end),' ',His.pep_seq,' +',num2str(His.pep_ch(1,1)),' ions'];

tmp_maxinten = max(pep_intens);
for ino=1:nplot
    subplot(nplot,1,ino);
    % XIC
    stem(pep_rts(ino),pep_intens(ino),'marker','none','color','b','linewidth',1);
    cur_txt = [His.mod_short{ino},'(',num2str(His.pep_mz(ino,1),'%.4f'),',',num2str(pep_intens(ino),'%.2e'),')'];
    text(pep_rts(ino),pep_intens(ino),cur_txt);
    set(gca,'xtick',[],'ytick',[]);
    if 1==ino
        title(cur_title);
    end
    if tmp_maxinten>0
        ylim([0 1.05*tmp_maxinten]);
    end
end
set(gca,'xtickMode', 'auto');
xlabel('Scan number');
ylabel('Abundance');
print('-dpdf',out_file1);
close();