function HH2B_02v_1_29(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'HH2B_02v_1_29';
fprintf(1,'%s..',out_filename(2:end));
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'unmod';
His.mod_short = {'1C.PEPAKSAPAPKKGSKKAVTKAQKKDGKKR';
    '1H.PDPAKSAPAPKKGSKKAVTKAQKKDGKKR';
    '2F.PDPAKSAPAPKKGSKKAVTKVQKKDGKKR';
    '1B.PEPSKSAPAPKKGSKKAITKAQKKDGKKR';
    '1N.PEPSKSAPAPKKGSKKAVTKAQKKDGKKR';
    '1D.PEPTKSAPAPKKGSKKAVTKAQKKDGKKR';
    '1M.PEPVKSAPVPKKGSKKAINKAQKKDGKKR';
    '1L.PELAKSAPAPKKGSKKAVTKAQKKDGKKR'};
His.mod_short2 = {'1C/1K/2E/1J';
    '1O/1H';
    '2F';
    '1B';
    '1N';
    '1D';
    '1M';
    '1L'};
His.mod_type = {'5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;'};

His.pep_ch = repmat(4,length(His.mod_type),1);
%{
His.pep_mz = [919.7816	1226.0398
    916.2777	1221.3679
    923.2856	1230.7117
    927.2843	1236.0433
    923.7804	1231.3714
    927.2843	1236.0433
    940.5500	1253.7309
    923.7895	1231.3835];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(14,'H2A_1_88',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));