function HH2BQC_00_1_28(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'HH2BQC_00_1_28';
%fprintf(1,'%s..',out_filename(2:end));
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'unmod';
His.mod_short = {'GVKFR';
    'GSTGGKAPR';
    'GKAPATSGMVGPHR';
    'GSTGGKAPR';
    'GKAPATSGMVGPHR';
    'GVKFRGSTGGKAPR';
    'GSTGGKAPRGKAPATSGMVGPHR';
    'GKAPATSGMVGPHR';
    'GSTGGK';
    'APATSGMVGPHR'};
His.mod_type = {'0,pr;3,pr;';
    '6,pr;';
    '2,pr;';
    '0,pr;2,pr;6,pr;';
    '0,pr;2,pr;7,pr;';
    '0,pr;3,pr;11,pr;';
    '6,pr;11,pr;';
    '2,pr;9,ox;';
    '';
    ''};

His.pep_ch = [1;2;2;2;2;2;3;2;1;2];%repmat(4,length(His.mod_type),1);
%{
His.pep_mz = [718.4243	359.7158	240.1463
886.4739	443.7406	296.1629
1421.7316	711.3695	474.5821
998.5259	499.7666	333.5135
1533.7836	767.3955	511.9328
1585.8803	793.4438	529.2983
2289.1877	1145.0975	763.7341
1437.7296	719.3685	479.9148
506.2570	253.6321	169.4239
1180.5892	590.7983	394.2013];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

ptol = 50;
pepno = get_pepno(48,'QC_peptides',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));