function HH2A_05m1_12_17(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'HH2A_05m1_12_17';
fprintf(1,'%s..',out_filename(2:end));
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'AKAKTR';
His.mod_short = {'unmod';
    'K13ac';
    'K15ac';
    'K15me1';
    'K13me1';
    'T16ac'};
His.mod_type = {'2,pr;4,pr;';
    '2,ac;4,pr;';
    '2,pr;4,ac;';
    '2,pr;4,me1;';
    '2,me1;4,pr;';
    '2,pr;4,pr;5,ac;'};

His.pep_ch = repmat(2,length(His.mod_type),1);
%{
His.pep_mz = [842.5094	421.7584
    828.4938	414.7505
    828.4938	414.7505
    856.5251	428.7662
    856.5251	428.7662
    884.5200	442.7636];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(13,'H2A1_12_17',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));

% H2A1un/H2A3K13me1
His1.pep_seq = 'unmod';
His1.mod_short = {'AKAKTR';
    'AKAKSR';
    'AKAKSR'};
His1.mod_type = {'2,pr;4,pr;';
    '2,pr;4,me1;';
    '2,me1;4,pr;'};
His1.pep_ch = repmat(2,length(His1.mod_type),1);
His1.pep_mz = calculate_pepmz(His1);
hno = [1 2 3];
pepno = get_pepno(42,'H2A1_12_17 H2A1unmod-H2A3K13me1-K15me1',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His1,pepno,length(special.pep_codes));%#ok
pep_intens(1) = pep_intens(1)*pep_ratio1(1);

% H2A1K13ac/H2A3un
His1.pep_seq = 'unmod';
His1.mod_short = {'AKAKTR';
    'AKAKTR';
    'AKAKSR'};
His1.mod_type = {'2,ac;4,pr;';
    '2,pr;4,ac;';
    '2,pr;4,pr;'};
His1.pep_ch = repmat(2,length(His1.mod_type),1);
His1.pep_mz = calculate_pepmz(His1);
hno = [1 2 3];
pepno = get_pepno(43,'H2A1_12_17 H2A1K13ac-K15ac-H2A3unmod',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His1,pepno,length(special.pep_codes));%#ok
pep_intens(2) = pep_intens(2)*pep_ratio1(1);
pep_intens(3) = pep_intens(3)*pep_ratio1(2);

% H2A1K13me1/H2A1K15me1
His1.pep_seq = 'unmod';
His1.mod_short = {'AKAKTR';
    'AKAKTR'};
His1.mod_type = {'2,pr;4,me1;';
    '2,me1;4,pr;'};
His1.pep_ch = repmat(2,length(His1.mod_type),1);
His1.pep_mz = calculate_pepmz(His1);
hno = [1 2];
pepno = get_pepno(44,'H2A1_12_17 H2A1K13me1-K15me1',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His1,pepno,length(special.pep_codes));%#ok
pep_intens(4) = pep_intens(4)*pep_ratio1(1);
pep_intens(5) = pep_intens(5)*pep_ratio1(2);