function HH1Mo_05v_54_81(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'HH1_05v_54_81';
fprintf(1,'%s..',out_filename(2:end));
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'unmod';
His.mod_short = {'H11.SGVSLAALKKSLAAAGYDVEKNNSR';
    'H1v234.SGVSLAALKKALAAAGYDVEKNNSR';
    'H15.GGVSLPALKKALAAGGYDVEKNNSR';
    'H1T.AGMSLAALKKALAAAGYDVEKNNSR'};
His.mod_type = {'9,pr;10,pr;21,pr;';
    '9,pr;10,pr;21,pr;';
    '9,pr;10,pr;21,pr;';
    '9,pr;10,pr;21,pr;'};

His.pep_ch = repmat(3,length(His.mod_type),1);
%{
His.pep_mz = [1364.2374	909.8274	682.6224
    1379.2427	919.8309	690.1250
    1392.7482	928.8345	696.8777
    1415.2625	943.8441	708.1349];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(9,'H1_1_35',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));