function HH1Mo_03o5_33_53(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'HH1_03o5_33_53';
fprintf(1,'%s..',out_filename(2:end));
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'KATGPPVSELITKAVSASKER';
His.mod_short = {'unmod';
    'K33me1';
    'K33me2';
    'K33me3';
    'K33ac';
    'S40ac'};
His.mod_type = {'1,pr;13,pr;19,pr;';
    '1,me1;13,pr;19,pr;';
    '1,me2;13,pr;19,pr;';
    '1,me3;13,pr;19,pr;';
    '1,ac;13,pr;19,pr;';
    '1,pr;8,ac;13,pr;19,pr;'};

His.pep_ch = repmat(3,length(His.mod_type),1);
%{
His.pep_mz = [1189.1705	793.1161	595.0889
    1196.1783	797.7880	598.5928
    1175.1730	783.7844	588.0902
    1182.1809	788.4563	591.5941
    1182.1627	788.4442	591.5850
    1210.1758	807.1196	605.5915
    1217.1836	811.7915	609.0954];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(29,'H12_33_53',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));