function H3_04v3a_27_40(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'H3_04v3a_27_40';
% fprintf(1,'%s..',out_filename);
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'KSAPSTGGVKKPHR';
His.mod_short = {'S28ph';
    'K27me1S28ph';
    'K27me2S28ph';
    'K27me3S28ph'};
His.mod_type = {'1,pr;2,ph;10,pr;11,pr;';
    '1,me1;2,ph;10,pr;11,pr;';
    '1,me2;2,ph;10,pr;11,pr;';
    '1,me3;2,ph;10,pr;11,pr;'};

His.pep_ch = repmat(3,length(His.mod_type),1);
%{
His.pep_mz = [869.4560	579.9731	435.2316
    876.4638	584.6450	438.7356
    855.4586	570.6415	428.2329
    862.4664	575.3133	431.7368];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(6,'H3_54_63',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));