function H3_04v3_27_40(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'H3_04v3_27_40';
%fprintf(1,'%s..',out_filename);
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'KSAPSTGGVKKPHR';
His.mod_short = {'unmod';
    'K36me1';
    'K27me1';
    'K27me2';
    'K36me2';
    'K27me3';
    'K36me3';
    'K27me2K36me1';
    'K27me1K36me2';
    'K27me1K36me1';
    'K27me3K36me1';
    'K27me1K36me3';
    'K27me2K36me2';
    'K27me3K36me2';
    'K27ac'};
His.mod_type = {'1,pr;10,pr;11,pr;';
    '1,pr;10,me1;11,pr;';
    '1,me1;10,pr;11,pr;';
    '1,me2;10,pr;11,pr;';
    '1,pr;10,me2;11,pr;';
    '1,me3;10,pr;11,pr;';
    '1,pr;10,me3;11,pr;';
    '1,me2;10,me1;11,pr;';
    '1,me1;10,me2;11,pr;';
    '1,me1;10,me1;11,pr;';
    '1,me3;10,me1;11,pr;';
    '1,me1;10,me3;11,pr;';
    '1,me2;10,me2;11,pr;';
    '1,me3;10,me2;11,pr;';
    '1,ac;10,pr;11,pr;'};

His.pep_ch = repmat(3,length(His.mod_type),1);
%{
His.pep_mz = [829.4728	553.3177	415.2401
    836.4807	557.9895	418.7440
    836.4807	557.9895	418.7440
    815.4754	543.9860	408.2413
    815.4754	543.9860	408.2413
    822.4832	548.6579	411.7452
    822.4832	548.6579	411.7452
    822.4832	548.6579	411.7452
    822.4832	548.6579	411.7452
    843.4885	562.6614	422.2479
    829.4910	553.3298	415.2492
    829.4910	553.3298	415.2492
    801.4779	534.6544	401.2426
    808.4858	539.3263	404.7465
    822.4650	548.6458	411.7361];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(5,'H33_27_40',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));

% K27me1/K36me1
hno = [2 3];
pepno = get_pepno(24,'H33_27_40 1me',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio1(i);
end

% K27me2/K36me2
hno = [4 5];
pepno = get_pepno(25,'H33_27_40 2me',special);
[cur_rts2,cur_intens2,pep_ratio2] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio2(i);
end

% K27me3/K36me3/K27me2K36me1/K27me1K36me2
hno = [6 7 8 9];
pepno = get_pepno(26,'H33_27_40 3me',special);
[cur_rts3,cur_intens3,pep_ratio3] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio3(i);
end

% K27me3K36me1/K27me1K36me3
hno = [11 12];
pepno = get_pepno(27,'H33_27_40 4me',special);
[cur_rts3,cur_intens3,pep_ratio3] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio3(i);
end