function K = get_key_ions2(His,hno,Mods,ActiveType)
%%

c_seq = His.pep_seq;
pno = hno(1);
qno = hno(2);
c_mod1 = His.mod_type{pno};
c_mod2 = His.mod_type{qno};

% get_mod_postype
[modpos1,modtype1] = get_mod_postype(c_seq,c_mod1,Mods);
[modpos2,modtype2] = get_mod_postype(c_seq,c_mod2,Mods);

newtype1 = modpos1*10000+modtype1;
newtype2 = modpos2*10000+modtype2;
comtype = intersect(newtype1,newtype2);
uniontype = union(newtype1,newtype2);
lefttype = setdiff(uniontype,comtype );
t1 = floor(min(lefttype)/10000);
if 0==t1
    t1 = 1;
end
t2 = floor(max(lefttype)/10000);
if His.pep_ch(1)>2
    c_ch = 2;
else
    c_ch = 1;
end
nlen = (t2-t1)*c_ch;
npep = length(hno);
K = zeros([npep,nlen]);

peplen = length(c_seq);
posn = t1:t2-1;
posc = (peplen-t2+1):(peplen-t1);

% get_theo_mz
for ix=1:npep
    c_mod1 = His.mod_type{hno(ix)};
    [theo_mz1,theo_tp1] = get_theo_mz(c_seq,c_mod1,c_ch,Mods,ActiveType);
    
    n1 = find(theo_tp1<2000);
    tpn1 = floor( (theo_tp1(n1)-1000)/10 );
    c1 = find(theo_tp1>2000);
    tpc1 = floor( (theo_tp1(c1)-2000)/10 );
    
    %{
    for ino=1:length(posn)
        loc1 = find(tpn1==posn(ino));
        if 1==length(loc1)
            K(ix,(ino-1)+1) = theo_mz1(n1(loc1));
        elseif 2==length(loc1)
            K(ix,2*(ino-1)+1) = theo_mz1(n1(loc1(1)));
            K(ix,2*(ino-1)+2) = theo_mz1(n1(loc1(2)));
        end
    end
    %}
    
    for ino=1:length(posc)
        loc1 = find(tpc1==posc(ino));
        if 1==length(loc1)
            K(ix,(ino-1)+1) = theo_mz1(c1(loc1));
        elseif 2==length(loc1)
            K(ix,2*(ino-1)+1) = theo_mz1(c1(loc1(1)));
            K(ix,2*(ino-1)+2) = theo_mz1(c1(loc1(2)));
        end
    end
end