function HH2BMo_02v_1_29(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'HH2B_02v_1_29';
fprintf(1,'%s..',out_filename(2:end));
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'unmod';
His.mod_short = {'1C.PEPAKSAPAPKKGSKKAVTKAQKKDGKKR';
    '1H.PEPAKSAPAPKKGSKKALTKAQKKDGKKR';
    '2B.PDPAKSAPAPKKGSKKAVTKVQKKDGKKR';
    '1B.PEPSKSAPAPKKGSKKAISKAQKKDGKKR';
    '3B.PDPSKSAPAPKKGSKKAVTKAQKKDGKKR';
    '1M.PEPTKSAPAPKKGSKKAVTKAQKKDGKKR';
    '1P.PEPVKSVPAPKKGSKKAVTKAQKKDGKKR';
    '2E.PELAKSAPAPKKGSKKAVTKAQKKDGKKR'};
His.mod_short2 = {'1C/1K/1J';
    '1H';
    '2B';
    '1B';
    '3B';
    '1M';
    '1P';
    '2E'};
His.mod_type = {'0,pr;5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '0,pr;5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '0,pr;5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '0,pr;5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '0,pr;5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '0,pr;5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '0,pr;5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;';
    '0,pr;5,pr;11,pr;12,pr;15,pr;16,pr;20,pr;23,pr;24,pr;27,pr;28,pr;'};

His.pep_ch = repmat(4,length(His.mod_type),1);
%{
His.pep_mz = [919.7816	1226.0397
    923.2855	1230.7116
    923.2855	1230.7116
    923.7804	1231.3714
    920.2764	1226.6995
    927.2843	1236.0433
    933.7973	1244.7273
    923.7895	1231.3835];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(14,'H2A_1_88',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));