function HH1_01o4_25_32(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'HH1_01o4_25_32';
fprintf(1,'%s..',out_filename(2:end));
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'KSAGAAKR';
His.mod_short = {'unmod';
    'K25me1';
    'K25me2';
    'K25me3';
    'K25ac';
    'K31ac';
    'S26ac';
    'S26ph'};
His.mod_type = {'0,pr;1,pr;7,pr;';
    '0,pr;1,me1;7,pr;';
    '0,pr;1,me2;7,pr;';
    '0,pr;1,me3;7,pr;';
    '0,pr;1,ac;7,pr;';
    '0,pr;1,pr;7,ac;';
    '0,pr;1,pr;2,ac;7,pr;';
    '0,pr;1,pr;2,ph;7,pr;'};

His.pep_ch = repmat(2,length(His.mod_type),1);
%{
His.pep_mz = [956.5524	478.7798
    970.5680	485.7876
    928.5574	464.7824
    942.5731	471.7902
    942.5367	471.7720
    942.5367	471.7720
    998.5629	499.7851
    1036.5187	518.7630];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(27,'H14_25_32',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));

% K25ac/K31ac
hno = [5 6];
pepno = get_pepno(28,'H14_25_32 K25ac-K31ac',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio1(i);
end