function H3_06_54_63(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'H3_06_54_63';
fprintf(1,'%s..',out_filename);
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'YQKSTELLIR';
His.mod_short = {'unmod';
    'K56me1';
    'K56me2';
    'K56me3';
    'K56ac'};
His.mod_type = {'0,pr;3,pr;';
    '0,pr;3,me1;';
    '0,pr;3,me2;';
    '0,pr;3,me3;';
    '0,pr;3,ac;'};

His.pep_ch = repmat(2,length(His.mod_type),1);
%{
His.pep_mz = [1362.7627	681.885	454.9258	341.4461
    1376.7784	688.8928	459.5976	344.9501
    1334.7678	667.8876	445.5941	334.4474
    1348.7835	674.8954	450.2660	337.9513
    1348.7471	674.8772	450.2539	337.9422];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(6,'H3_54_63',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));