function H3_03_18_26(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'H3_03_18_26';
fprintf(1,'%s..',out_filename);
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'KQLATKAAR';
His.mod_short = {'unmod';
    'K23me1';
    'K18me1';
    'K18me1K23me1';
    'K18ac';
    'K23ac';
    'K18acK23ac'};
His.mod_type = {'0,pr;1,pr;6,pr;';
    '0,pr;1,pr;6,me1;';
    '0,pr;1,me1;6,pr;';
    '0,pr;1,me1;6,me1;';
    '0,pr;1,ac;6,pr;';
    '0,pr;1,pr;6,ac;';
    '0,pr;1,ac;6,ac;'};

His.pep_ch = repmat(2,length(His.mod_type),1);
%{
His.pep_mz = [1154.6892	577.8482	385.5679
    1168.7048	584.8561	390.2398
    1168.7048	584.8561	390.2398
    1182.7205	591.8639	394.9117
    1140.6735	570.8404	380.8960
    1140.6735	570.8404	380.8960
    1126.6579	563.8326	376.2241];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(1,'H3_3_8',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));

% K18ac/K23ac
hno = [5 6];
pepno = get_pepno(18,'H3_18_26 K18ac-K23ac',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio1(i);
end

% K18me1/K23me1
hno = [2 3];
pepno = get_pepno(19,'H3_18_26 K18me1-K23me1',special);
[cur_rts2,cur_intens2,pep_ratio2] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio2(i);
end