function H3_02a_9_17(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'H3_02a_9_17';
%fprintf(1,'%s..',out_filename);
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'KSTGGKAPR';
His.mod_short = {'S10ph';
    'K9me1S10ph';
    'K9me2S10ph';
    'K9me3S10ph';
    'K9acS10ph';
    'S10phK14ac';
    'K9me1S10phK14ac';
    'K9me2S10phK14ac';
    'K9me3S10phK14ac';
    'K9acS10phK14ac'};
His.mod_type = {'0,pr;1,pr;2,ph;6,pr;';
    '0,pr;1,me1;2,ph;6,pr;';
    '0,pr;1,me2;2,ph;6,pr;';
    '0,pr;1,me3;2,ph;6,pr;';
    '0,pr;1,ac;2,ph;6,pr;';
    '0,pr;1,pr;2,ph;6,ac;';
    '0,pr;1,me1;2,ph;6,ac;';
    '0,pr;1,me2;2,ph;6,ac;';
    '0,pr;1,me3;2,ph;6,ac;';
    '0,pr;1,ac;2,ph;6,ac;'};

His.pep_ch = repmat(2,length(His.mod_type),1);
%{
His.pep_mz = [1149.5664	575.2868	383.8603
    1163.5820	582.2946	388.5322
    1121.5715	561.2894	374.5287
    1135.5871	568.2972	379.2006
    1135.5507	568.2790	379.1884
    1135.5507	568.2790	379.1884
    1149.5664	575.2868	383.8603
    1107.5558	554.2815	369.8568
    1121.5715	561.2894	374.5287
    1121.5351	561.2712	374.5165];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(4,'H3_9_17ph',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));

% S10ph/K9me1S10phK14ac
hno = [1 7];
pepno = get_pepno(45,'H3_9_17ph S10ph-K9me1S10phK14ac',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio1(i);
end

% K9me2S10ph/K9me3S10phK14ac
hno = [3 9];
pepno = get_pepno(46,'H3_9_17ph K9me2S10ph-K9me3S10phK14ac',special);
[cur_rts2,cur_intens2,pep_ratio2] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio2(i);
end

% K9acS10ph/S10phK14ac
hno = [5 6];
pepno = get_pepno(47,'H3_9_17ph K9acS10ph-S10phK14ac',special);
[cur_rts3,cur_intens3,pep_ratio3] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio3(i);
end