function H3_01_3_8(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'H3_01_3_8';
fprintf(1,'%s..',out_filename);
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'TKQTAR';
His.mod_short = {'unmod';
    'K4me1';
    'K4me2';
    'K4me3';
    'K4ac'};
His.mod_type = {'0,pr;2,pr;';
    '0,pr;2,me1;';
    '0,pr;2,me2;';
    '0,pr;2,me3;';
    '0,pr;2,ac;'};

His.pep_ch = repmat(2,length(His.mod_type),1);
%{
His.pep_mz = [816.4574	408.7323
    830.4730	415.7402
    788.4625	394.7349
    802.4781	401.7427
    802.4417	401.7245];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(1,'H3_3_8',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));