function [pep_codes,pre_nums] = read_peptidelist()
%%

pep_codes = [];
pre_nums = primes(100000);

list_file = 'hist.txt';
if 0==exist(list_file,'file')
    fprintf(1,'no hist.txt. please put all histone peptides into hist.txt under the folder of the program\n');
    return;
end

fp = fopen(list_file,'r');
if -1==fp
    fprintf(1,'can not open: %s\n',list_file);
    return;
end

str = fgetl(fp);
no = 0;
while 0==feof(fp)
    if 0==isempty(str)
        no = no + 1;
        pep_codes(no,1) = sum((str-'0'+49).*log(pre_nums(1:length(str))));%#ok
    end
    str = fgetl(fp);
end
if 0==isempty(str)
    no = no + 1;
    pep_codes(no,1) = sum((str-'0'+49).*log(pre_nums(1:length(str))));
end

fclose(fp);