function HH2A_07v_1_88(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'HH2A_07v_1_88';
fprintf(1,'%s..',out_filename(2:end));
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'unmod';
His.mod_short = {'H2A14s.HLQLAIR';
    'H2AZ.AGGKAGKDSGKAKTKAVSR';
    'H2AY.SAKAGVIFPVGR';
    'H2AX.GKTGGKAR'};
His.mod_type = {'';
    '4,pr;7,pr;11,pr;13,pr;15,pr;';
    '3,pr;';
    '2,pr;6,pr;'};

His.pep_ch = [2;3;2;2];%repmat([3 2 1],length(His.mod_type),1);
%{
His.pep_mz = [302.8555	453.7796	906.5520
    718.4023	1077.0999	2153.1925
    438.5907	657.3824	1313.7576
    314.8504	471.7720	942.5367];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(14,'H2A_1_88',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));