function HH2A_04oZ_1_19(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'HH2A_04oZ_1_19';
% fprintf(1,'%s..',out_filename(2:end));
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'AGGKAGKDSGKAKTKAVSR';
His.mod_short = {'unmod';
    'K4ac';
    'K7ac';
    'K11ac';
    'K15ac';
    'K4acK7ac';
    'K4acK11ac';
    'K4acK15ac';
    'K7acK11ac';
    'K7acK15ac';
    'K11acK15ac';
    'K7acK11acK15ac';
    'K4acK11acK15ac';
    'K4acK7acK15ac';
    'K4acK7acK11ac';
    'K4acK7acK11acK15ac'};
His.mod_type = {'4,pr;7,pr;11,pr;13,pr;15,pr;';
    '4,ac;7,pr;11,pr;13,pr;15,pr;';
    '4,pr;7,ac;11,pr;13,pr;15,pr;';
    '4,pr;7,pr;11,ac;13,pr;15,pr;';
    '4,pr;7,pr;11,pr;13,pr;15,ac;';
    '4,ac;7,ac;11,pr;13,pr;15,pr;';
    '4,ac;7,pr;11,ac;13,pr;15,pr;';
    '4,ac;7,pr;11,pr;13,pr;15,ac;';
    '4,pr;7,ac;11,ac;13,pr;15,pr;';
    '4,pr;7,ac;11,pr;13,pr;15,ac;';
    '4,pr;7,pr;11,ac;13,pr;15,ac;';
    '4,pr;7,ac;11,ac;13,pr;15,ac;';
    '4,ac;7,pr;11,ac;13,pr;15,ac;';
    '4,ac;7,ac;11,pr;13,pr;15,ac;';
    '4,ac;7,ac;11,ac;13,pr;15,pr;';
    '4,ac;7,ac;11,ac;13,pr;15,ac;'};

His.pep_ch = repmat(3,length(His.mod_type),1);
%{
His.pep_mz = [1077.0999	718.4023	539.0536	431.4443
    1070.0920	713.7305	535.5497	428.6412
    1070.0920	713.7305	535.5497	428.6412
    1070.0920	713.7305	535.5497	428.6412
    1070.0920	713.7305	535.5497	428.6412
    1063.0842	709.0586	532.0457	425.8381
    1063.0842	709.0586	532.0457	425.8381
    1063.0842	709.0586	532.0457	425.8381
    1063.0842	709.0586	532.0457	425.8381
    1063.0842	709.0586	532.0457	425.8381
    1063.0842	709.0586	532.0457	425.8381
    1056.0764	704.3867	528.5418	423.0349
    1056.0764	704.3867	528.5418	423.0349
    1056.0764	704.3867	528.5418	423.0349
    1056.0764	704.3867	528.5418	423.0349
    1049.0686	699.7148	525.0379	420.2318];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(12,'H2AV_1_19',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));

% K5ac/K8ac/K12ac/K16ac
hno = [2 3 4 5];
pepno = get_pepno(39,'H2AZ_1_19 1ac',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone4(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio1(i);
end

% K5acK8ac/K5acK12ac/K5acK16ac/K8acK12ac/K8acK16ac/K12acK16ac
hno = [6 7 8 9 10 11];
pepno = get_pepno(40,'H2AZ_1_19 2ac',special);
[cur_rts2,cur_intens2,pep_ratio2] = get_histone6(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio2(i);
end

% K8acK12acK16ac/K5acK12acK16ac/K5acK8acK16ac/K5acK8acK12ac
hno = [12 13 14 15];
pepno = get_pepno(41,'H2AZ_1_19 3ac',special);
[cur_rts3,cur_intens3,pep_ratio3] = get_histone4(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio3(i);
end