function HH2A_02m1_4_11(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'HH2A_02m1_4_11';
fprintf(1,'%s..',out_filename(2:end));
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'GKQGGKAR';
His.mod_short = {'unmod';
    'K5ac';
    'K9ac';
    'K5acK9ac';
    'K9me1';
    'K5me1'};
His.mod_type = {'2,pr;6,pr;';
    '2,ac;6,pr;';
    '2,pr;6,ac;';
    '2,ac;6,ac;';
    '2,pr;6,me1;';
    '2,me1;6,pr;'};

His.pep_ch = repmat(2,length(His.mod_type),1);
%{
His.pep_mz = [969.5476	485.2774
    955.5320	478.2696
    955.5320	478.2696
    941.5163	471.2618
    983.5633	492.2853
    983.5633	492.2853];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(11,'H2A1_4_11',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));

% K5ac/K9ac
hno = [2 3];
pepno = get_pepno(31,'H2A1_4_11 K5ac-K9ac',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio1(i);
end

% H2A1me1/H2AJac
His1.pep_seq = 'unmod';
His1.mod_short = {'GKQGGKAR';
    'GKQGGKAR';
    'GKQGGKVR';
    'GKQGGKVR'};
His1.mod_type = {'2,pr;6,me1;';
    '2,me1;6,pr;';
    '2,ac;6,pr;';
    '2,pr;6,ac;'};
His1.pep_ch = repmat(2,length(His1.mod_type),1);
His1.pep_mz = calculate_pepmz(His1);
hno = [1 2 3 4];
pepno = get_pepno(32,'H2A1_4_11 H2A1K5me1-K9me1-H2AJK5ac-K9ac',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His1,pepno,length(special.pep_codes));%#ok
pep_intens(5) = pep_intens(5)*pep_ratio1(1);
pep_intens(6) = pep_intens(6)*pep_ratio1(2);