function HH1_03o5_36_56(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'HH1_03o5_36_56';
fprintf(1,'%s..',out_filename(2:end));
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'KATGPPVSELITKAVAASKER';
His.mod_short = {'unmod';
    'K36me1';
    'K36me2';
    'K36me3';
    'K36ac';
    'S43ac'};
His.mod_type = {'1,pr;13,pr;19,pr;';
    '1,me1;13,pr;19,pr;';
    '1,me2;13,pr;19,pr;';
    '1,me3;13,pr;19,pr;';
    '1,ac;13,pr;19,pr;';
    '1,pr;8,ac;13,pr;19,pr;'};

His.pep_ch = repmat(3,length(His.mod_type),1);
%{
His.pep_mz = [1189.1705	793.1161	595.0889
    1196.1783	797.7880	598.5928
    1175.1730	783.7844	588.0902
    1182.1809	788.4563	591.5941
    1182.1627	788.4442	591.5850
    1210.1758	807.1196	605.5915
    1217.1836	811.7915	609.0954];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(29,'H12_33_53',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));

% H12un/H15K36ac
His1.pep_seq = 'unmod';
His1.mod_short = {'KASGPPVSELITKAVAASKER';
    'KATGPPVSELITKAVAASKER'};
His1.mod_type = {'1,pr;13,pr;19,pr;';
    '1,ac;13,pr;19,pr;'};
His1.pep_ch = repmat(3,length(His1.mod_type),1);
His1.pep_mz = calculate_pepmz(His1);
hno = [1 2];
pepno = get_pepno(30,'H12_33_53 H12unmod-H15K36ac',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His1,pepno,length(special.pep_codes));%#ok
pep_intens(5) = pep_intens(5)*pep_ratio1(2);

% H12K33me1/H15un
His1.pep_seq = 'unmod';
His1.mod_short = {'KASGPPVSELITKAVAASKER';
    'KATGPPVSELITKAVAASKER'};
His1.mod_type = {'1,me1;13,pr;19,pr;';
    '1,pr;13,pr;19,pr;'};
His1.pep_ch = repmat(3,length(His1.mod_type),1);
His1.pep_mz = calculate_pepmz(His1);
hno = [1 2];
pepno = get_pepno(31,'H12_33_53 H12K33me1-H15unmod',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His1,pepno,length(special.pep_codes));%#ok
pep_intens(1) = pep_intens(1)*pep_ratio1(2);

% H12K33me3/H15K36me2
His1.pep_seq = 'unmod';
His1.mod_short = {'KASGPPVSELITKAVAASKER';
    'KATGPPVSELITKAVAASKER'};
His1.mod_type = {'1,me3;13,pr;19,pr;';
    '1,me2;13,pr;19,pr;'};
His1.pep_ch = repmat(3,length(His1.mod_type),1);
His1.pep_mz = calculate_pepmz(His1);
hno = [1 2];
pepno = get_pepno(32,'H12_33_53 H12K33me3-H15K36me2',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His1,pepno,length(special.pep_codes));%#ok
pep_intens(3) = pep_intens(3)*pep_ratio1(2);