function H4_01_4_17(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'H4_01_4_17';
fprintf(1,'%s..',out_filename);
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);
[His,pep_rts,pep_intens] = change_order(His,pep_rts,pep_intens);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'GKGGKGLGKGGAKR';
His.mod_short = {'unmod';
    'K5ac';
    'K8ac';
    'K12ac';
    'K16ac';
    'K5acK8ac';
    'K5acK12ac';
    'K5acK16ac';
    'K8acK12ac';
    'K8acK16ac';
    'K12acK16ac';
    'K8acK12acK16ac';
    'K5acK12acK16ac';
    'K5acK8acK16ac';
    'K5acK8acK12ac';
    'K5acK8acK12acK16ac'};
His.mod_type = {'2,pr;5,pr;9,pr;13,pr;';
    '2,ac;5,pr;9,pr;13,pr;';
    '2,pr;5,ac;9,pr;13,pr;';
    '2,pr;5,pr;9,ac;13,pr;';
    '2,pr;5,pr;9,pr;13,ac;';
    '2,ac;5,ac;9,pr;13,pr;';
    '2,ac;5,pr;9,ac;13,pr;';
    '2,ac;5,pr;9,pr;13,ac;';
    '2,pr;5,ac;9,ac;13,pr;';
    '2,pr;5,ac;9,pr;13,ac;';
    '2,pr;5,pr;9,ac;13,ac;';
    '2,pr;5,ac;9,ac;13,ac;';
    '2,ac;5,pr;9,ac;13,ac;';
    '2,ac;5,ac;9,pr;13,ac;';
    '2,ac;5,ac;9,ac;13,pr;';
    '2,ac;5,ac;9,ac;13,ac;'};

His.pep_ch = repmat(2,length(His.mod_type),1);
%{
His.pep_mz = [1550.9013	775.9543	517.6386	388.4808
    1536.8857	768.9465	512.9667	384.9769
    1536.8857	768.9465	512.9667	384.9769
    1536.8857	768.9465	512.9667	384.9769
    1536.8857	768.9465	512.9667	384.9769
    1522.8700	761.9386	508.2949	381.473
    1522.8700	761.9386	508.2949	381.473
    1522.8700	761.9386	508.2949	381.473
    1522.8700	761.9386	508.2949	381.473
    1522.8700	761.9386	508.2949	381.473
    1522.8700	761.9386	508.2949	381.473
    1508.8544	754.9308	503.6230	377.969
    1508.8544	754.9308	503.6230	377.969
    1508.8544	754.9308	503.6230	377.969
    1508.8544	754.9308	503.6230	377.969
    1494.8387	747.9230	498.9511	374.4651];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(8,'H4_4_17',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));

% K5ac/K8ac/K12ac/K16ac
hno = [2 3 4 5];
pepno = get_pepno(28,'H4_4_17 1ac',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone4(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio1(i);
end

% K5acK8ac/K5acK12ac/K5acK16ac/K8acK12ac/K8acK16ac/K12acK16ac
hno = [6 7 8 9 10 11];
pepno = get_pepno(29,'H4_4_17 2ac',special);
[cur_rts2,cur_intens2,pep_ratio2] = get_histone6(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio2(i);
end

% K8acK12acK16ac/K5acK12acK16ac/K5acK8acK16ac/K5acK8acK12ac
hno = [12 13 14 15];
pepno = get_pepno(30,'H4_4_17 3ac',special);
[cur_rts3,cur_intens3,pep_ratio3] = get_histone4(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio3(i);
end

function [His,pep_rts,pep_intens] = change_order(His,pep_rts,pep_intens)
%% 12,13,14,15->15,14,13,12

% copy
b1 = His.mod_short{15};
b2 = His.mod_short{14};
b3 = His.mod_short{13};
b4 = His.mod_short{12};

c1 = His.mod_type{15};
c2 = His.mod_type{14};
c3 = His.mod_type{13};
c4 = His.mod_type{12};

e1 = pep_rts(15,:);
e2 = pep_rts(14,:);
e3 = pep_rts(13,:);
e4 = pep_rts(12,:);

f1 = pep_intens(15,:);
f2 = pep_intens(14,:);
f3 = pep_intens(13,:);
f4 = pep_intens(12,:);

% paste
His.mod_short{12} = b1;
His.mod_short{13} = b2;
His.mod_short{14} = b3;
His.mod_short{15} = b4;

His.mod_type{12} = c1;
His.mod_type{13} = c2;
His.mod_type{14} = c3;
His.mod_type{15} = c4;

pep_rts(12,:) = e1;
pep_rts(13,:) = e2;
pep_rts(14,:) = e3;
pep_rts(15,:) = e4;

pep_intens(12,:) = f1;
pep_intens(13,:) = f2;
pep_intens(14,:) = f3;
pep_intens(15,:) = f4;