function H3_07_73_83(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'H3_07_73_83';
fprintf(1,'%s..',out_filename);
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'EIAQDFKTDLR';
His.mod_short = {'unmod';
    'K79me1';
    'K79me2';
    'K79me3';
    'K79ac'};
His.mod_type = {'7,pr;';
    '7,me1;';
    '7,me2;';
    '7,me3;';
    '7,ac;'};

His.pep_ch = repmat(2,length(His.mod_type),1);
%{
His.pep_mz = [1447.7427	724.375	483.2524	362.6911
    1461.7584	731.3828	487.9243	366.1951
    1419.7478	710.3775	473.9208	355.6924
    1433.7635	717.3854	478.5927	359.1963
    1433.7271	717.3672	478.5805	359.1872];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(7,'H3_73_83',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));