function H3_02_9_17(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'H3_02_9_17';
fprintf(1,'%s..',out_filename);
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'KSTGGKAPR';
His.mod_short = {'unmod';
    'K9me1';
    'K9me2';
    'K9me3';
    'K9ac';
    'K14ac';
    'K9me1K14ac';
    'K9me2K14ac';
    'K9me3K14ac';
    'K9acK14ac'};
His.mod_type = {'1,pr;6,pr;';
    '1,me1;6,pr;';
    '1,me2;6,pr;';
    '1,me3;6,pr;';
    '1,ac;6,pr;';
    '1,pr;6,ac;';
    '1,me1;6,ac;';
    '1,me2;6,ac;';
    '1,me3;6,ac;';
    '1,ac;6,ac;'};

His.pep_ch = repmat(2,length(His.mod_type),1);
%{
His.pep_mz = [1069.6	535.3037	357.2049
    1083.6157	542.3115	361.8767
    1041.6051	521.3062	347.8732
    1055.6208	528.3140	352.5451
    1055.5844	528.2958	352.533
    1055.5844	528.2958	352.533
    1069.6000	535.3037	357.2049
    1027.5895	514.2984	343.2013
    1041.6051	521.3062	347.8732
    1041.5687	521.2880	347.8611];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(2,'H3_9_17',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));

% K9ac/K14ac
hno = [5 6];
pepno = get_pepno(15,'H3_9_17 K9ac-K14ac',special);
[cur_rts1,cur_intens1,pep_ratio1] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio1(i);
end

% unmod/K9me1K14ac
hno = [1 7];
pepno = get_pepno(16,'H3_9_17 unmod-K9me1K14ac',special);
[cur_rts2,cur_intens2,pep_ratio2] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio2(i);
end

% K9me2/K9me3K14ac
hno = [3 9];
pepno = get_pepno(17,'H3_9_17 K9me2-K9me3K14ac',special);
[cur_rts3,cur_intens3,pep_ratio3] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,length(special.pep_codes));%#ok
for i=1:length(hno)
    pep_intens(hno(i)) = pep_intens(hno(i))*pep_ratio3(i);
end