function [pep_rts,pep_intens,pep_ratio] = get_histone4(MS2_index,MS2_peaks,hno,His,pepno,delta)
%%

% select MS scan
pts = [];
snum = 0;
ndata = 5;
for i=1:ndata
    p = find( MS2_index(:,3)==pepno+(i-1)*delta );
    if 1==isempty(p)
        break;
    end
    snum = snum + 1;
    pts(1,snum) = p;%#ok
end

npep = length(hno);
pep_rts = zeros([npep,snum]);%#ok
pep_intens = zeros([npep,snum]);%#ok
if 0==snum
    pep_rts = zeros([npep,1]);
    pep_intens = zeros([npep,1]);
    pep_ratio = repmat(1/npep,[npep,1]);
    return;
end

Mods = GetMods();
instruments = MS2_index(pts,6);% MS2dirs = {'CIDIT','CIDFT','ETDIT','ETDFT','HCDIT','HCDFT'};
% ActiveType, tol
c_instrument = instruments(1);
if 3==c_instrument || 4==c_instrument
    ActiveType = 'ETD';
else
    ActiveType = 'CID';
end
if 1==mod(c_instrument,2)
    tol = 0.4;
else
    tol = 0.02;
end

% K1,K2
% K = get_key_ions(His,hno,Mods,ActiveType);
K1 = get_key_ions(His,[hno(1) hno(2)],Mods,ActiveType);
K2 = get_key_ions(His,[hno(2) hno(3)],Mods,ActiveType);
K3 = get_key_ions(His,[hno(3) hno(4)],Mods,ActiveType);
pep_rts0 = zeros([2,snum]);
pep_intens1 = zeros([2,snum]);
pep_intens2 = zeros([2,snum]);
pep_intens3 = zeros([2,snum]);

num_MS2 = size(MS2_index,1);
index = [1;MS2_index(1:num_MS2,7)];
for jno=1:snum
    pno = pts(jno);
    cur_rts = MS2_index(pno,3);% MS2 scan
    
    IX = index(pno):index(pno+1)-1;
    mz = MS2_peaks(IX,1);
    inten = MS2_peaks(IX,2);
    for ino=1:2
        pep_rts0(ino,jno) = cur_rts;
        K1x = K1(ino,:);
        K1x = unique(K1x);
        for kno=1:length(K1x)
            ix1 = find(abs(mz-K1x(kno))<=tol);
            if 0==isempty(ix1)
                pep_intens1(ino,jno) = pep_intens1(ino,jno)+max(inten(ix1));
            end
        end
        
        K2x = K2(ino,:);
        K2x = unique(K2x);
        for kno=1:length(K2x)
            ix1 = find(abs(mz-K2x(kno))<=tol);
            if 0==isempty(ix1)
                pep_intens2(ino,jno) = pep_intens2(ino,jno)+max(inten(ix1));
            end
        end
        
        K3x = K3(ino,:);
        K3x = unique(K3x);
        for kno=1:length(K3x)
            ix1 = find(abs(mz-K3x(kno))<=tol);
            if 0==isempty(ix1)
                pep_intens3(ino,jno) = pep_intens3(ino,jno)+max(inten(ix1));
            end
        end
    end
end

% multi data points
if snum>1
    [pep_rts1,pep_intens1] = get_most_column(pep_rts0,pep_intens1);%#ok
    [pep_rts2,pep_intens2] = get_most_column(pep_rts0,pep_intens2);%#ok
    [pep_rts3,pep_intens3] = get_most_column(pep_rts0,pep_intens3);%#ok
end

if 0==sum(pep_intens1) && 0==sum(pep_intens2) && 0==sum(pep_intens3)
    pep_rts = zeros([npep,1]);
    pep_intens = zeros([npep,1]);
    pep_ratio = repmat(1/npep,[npep,1]);
else
    pep_rts = repmat(pep_rts0(1,1),[npep,1]);
    a = sum(pep_intens1(1))/(eps+sum(pep_intens1(1))+sum(pep_intens1(2)));
    ab = sum(pep_intens2(1))/(eps+sum(pep_intens2(1))+sum(pep_intens2(2)));
    abc = sum(pep_intens3(1))/(eps+sum(pep_intens3(1))+sum(pep_intens3(2)));
    d = 1-abc;
    b = max([ab-a 0]);
    c = 1-a-b-d;
    if a+d>1
        d = 1-a;
        b = 0;
        c = 0;
    elseif a+d+b>1
        b = 1-a-d;
        c = 0;
    end
    X = [a;b;c;d];
    pep_intens = X;
    pep_ratio = X;
end