function [pep_rts,pep_intens,pep_ratio] = get_histone2(MS2_index,MS2_peaks,hno,His,pepno,delta)
%%

% select MS scan
pts = [];
snum = 0;
ndata = 5;
for i=1:ndata
    p = find( MS2_index(:,3)==pepno+(i-1)*delta );
    if 1==isempty(p)
        break;
    end
    snum = snum + 1;
    pts(1,snum) = p;%#ok
end

npep = length(hno);
pep_rts = zeros([npep,snum]);
pep_intens = zeros([npep,snum]);
if 0==snum
    pep_rts = zeros([npep,1]);
    pep_intens = zeros([npep,1]);
    pep_ratio = repmat(1/npep,[npep,1]);
    return;
end

Mods = GetMods();
instruments = MS2_index(pts,6);% MS2dirs = {'CIDIT','CIDFT','ETDIT','ETDFT','HCDIT','HCDFT'};
% ActiveType, tol
c_instrument = instruments(1);
if 3==c_instrument || 4==c_instrument
    ActiveType = 'ETD';
else
    ActiveType = 'CID';
end
if 1==mod(c_instrument,2)
    tol = 0.4;
else
    tol = 0.02;
end

% K1,K2
K = get_key_ions(His,hno,Mods,ActiveType);

num_MS2 = size(MS2_index,1);
index = [1;MS2_index(1:num_MS2,7)];
for jno=1:snum
    pno = pts(jno);
    cur_rts = MS2_index(pno,3);% MS2 scan
    
    IX = index(pno):index(pno+1)-1;
    mz = MS2_peaks(IX,1);
    inten = MS2_peaks(IX,2);
    for ino=1:npep
        pep_rts(ino,jno) = cur_rts;
        K1 = K(ino,:);
        K1 = unique(K1);
        for kno=1:length(K1)
            ix1 = find(abs(mz-K1(kno))<=tol);
            if 0==isempty(ix1)
                pep_intens(ino,jno) = pep_intens(ino,jno)+max(inten(ix1));
            end
        end
    end
end

% multi data points
if snum>1
    [pep_rts,pep_intens] = get_most_column(pep_rts,pep_intens);
end

if 0==sum(pep_intens)
    pep_ratio = repmat(1/npep,[npep,1]);
else
    pep_ratio = pep_intens/sum(pep_intens);
end