function HH1Mo_04v_1_35(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,cur_outpath,special)
%%

% check
out_filename = 'HH1_04v_1_35';
fprintf(1,'%s..',out_filename(2:end));
out_file0 = fullfile(cur_outpath,[out_filename,'.mat']);
if 0~=exist(out_file0,'file')
    return;
end

% init
His = init_histone();

% calculate
[pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special);

% output
output_histone(cur_outpath,out_filename,His,pep_rts,pep_intens);

% draw
draw_layout(cur_outpath,out_filename,His,pep_rts,pep_intens);

function His = init_histone()
%%

His.pep_seq = 'unmod';
His.mod_short = {'H11.SETAPVAQAASTATEKPAAAKKTKKPAKAAAPR';
    'H12.SEAAPAAPAAAPPAEKAPAKKKAAKKPAGVR';
    'H13.SETAPAAPAAPAPVEKTPVKKKAKKTGAAAGKR';
    'H14.SETAPAAPAAPAPAEKTPVKKKAR';
    'H15.SETAPAETAAPAPVEKSPAKKKTTKKAGAAKR';};
His.mod_type = {'0,pr;16,pr;21,pr;22,pr;24,pr;25,pr;28,pr;';
    '0,pr;16,pr;20,pr;21,pr;22,pr;25,pr;26,pr;';
    '0,pr;16,pr;20,pr;21,pr;22,pr;24,pr;25,pr;32,pr;';
    '0,pr;16,pr;20,pr;21,pr;22,pr;';
    '0,pr;16,pr;20,pr;21,pr;22,pr;25,pr;26,pr;31,pr;'};

His.pep_ch = [4;4;4;3;4];%repmat([3 4 5],length(His.mod_type),1);
%{
His.pep_mz = [1153.9785	865.7357	692.7900
    1153.9785	865.7357	692.7900
    1254.7187	941.2908	753.2341
    889.8287	667.6234	534.3001
    1290.0404	967.7821	774.4271];
%}
His.pep_mz = calculate_pepmz(His);

function [pep_rts,pep_intens] = calculate_layout(MS1_index,MS1_peaks,MS2_index,MS2_peaks,ptol,His,special)%#ok
%%

pepno = get_pepno(9,'H1_1_35',special);
[pep_rts,pep_intens] = get_histone1(MS1_index,MS1_peaks,ptol,His,pepno,length(special.pep_codes));