#!/bin/bash
# a custom perl script for isolating and reformatting complex repeats during MAKER

# Referred https://gist.github.com/darencard/bb1001ac1532dd4225b030cf0cd61ce2
# Repeat Annotation - 2. Full Repeat Annotation

# Create GFF3
rmOutToGFF3.pl cb4856.qv2.bac.pilon2.scaffold.gap.mt.fasta.out > cb4856.qv2.bac.pilon2.scaffold.gap.mt.gff3

# Isolate complex repeats
grep -v -e "Satellite" -e ")n" -e "-rich" cb4856.qv2.bac.pilon2.scaffold.gap.mt.gff3 \\n  > cb4856.qv2.bac.pilon2.scaffold.gap.mt.complex.gff3

# Reformat to work with MAKER
cat cb4856.qv2.bac.pilon2.scaffold.gap.mt.complex.gff3  | \\n  perl -ane '$id; if(!/^\#/){@F = split(/\t/, $_); chomp $F[-1];$id++; $F[-1] .= "\;ID=$id"; $_ = join("\t", @F)."\n"} print $_' \\n  > cb4856.qv2.bac.pilon2.scaffold.gap.mt.complex.reformat.gff3