/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.jdom2.Element;

/**
 *
 * @author gevirl
 */
public class Transfer {
    public Transfer(Element mapElement) throws Exception{    
        panelClass = mapElement.getAttributeValue("panel");
        name = mapElement.getAttributeValue("name");
        String req = mapElement.getAttributeValue("required");
        if (req != null){
            String[] tokens = req.split(",");
            for (String token : tokens){
                requiredColumns.add(token);
            }
        }
        List<Element> children = mapElement.getChildren("Mapping");
        for (Element child : children){
            String from = child.getAttributeValue("from");
            String to = child.getAttributeValue("to");
            
            String required = child.getAttributeValue("required");
            if (required!=null){
                requiredColumns.add(from);
            }

            String checked = child.getAttributeValue("checked");
            if (checked!=null){
                checkedPairings.put(from, to);
            }
            
            pairings.put(from, to);
        }
        repeat = mapElement.getAttributeValue("repeat");
        if (repeat != null){
            try {
                repeat = Integer.parseInt((String)repeat);
            } catch (Exception exc){
               // get here if repeat is not an integer - use a column to get the repeat value
            }
        } else {
            repeat = 1;
        }
        
    }
    public String getName(){
        return name;
    }
    public String getPanelClass(){
        return panelClass;
    }
    public LinkedHashMap<String,String> getPairings(){
        return pairings;
    }
    public Object getRepeat(){
        return repeat;
    }

    public String[] getRequiredColumns(){
        return requiredColumns.toArray(new String[0]);
    }
    // returns the columns in the destination panel that should be checked for duplication before transfer
    public HashMap<String,String> getCheckedPairings(){
        return checkedPairings;
    }
    public boolean isRequired(String column){
        for (String req : this.requiredColumns){
            if (req.equals(column)){
                return true;
            }
        }
        return false;
    }

    Object repeat;  // if String then column to get integer repeat
    String name;
    String panelClass;
    ArrayList<String> requiredColumns = new ArrayList<String>();
    HashMap<String,String> checkedPairings = new HashMap<String,String>();
    LinkedHashMap<String,String> pairings = new LinkedHashMap<String,String>();
}
