/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jdom2.Element;

/**
 *
 * @author gevirl
 */
    public class Mapping{
        public Mapping(Element mappingEle){
            property = mappingEle.getAttributeValue("property");
             
            String header = mappingEle.getAttributeValue("header");
            String format = mappingEle.getAttributeValue("format");
            String remove = mappingEle.getAttributeValue("remove");
            optional = mappingEle.getAttribute("Optional")!=null;
            arrayType = header==null && format==null;
            
            if (arrayType){
                List<Element> entryChildren = mappingEle.getChildren("Entry");
                for (Element child : entryChildren){
                    Entry entry = new Entry(child);
                    if (remove != null){
                        entry.setRemove(remove);
                    }
                    entryList.add(entry);
                }
            } else {
                Entry entry = new Entry(header, format);
                if (remove != null){
                    entry.setRemove(remove);
                }
                entryList.add(entry);
            }
        }
        
        public String[] dataValue(Map<String,String> data){
            ArrayList<String> dataList = new ArrayList<>();
            for (int i=0; i<entryList.size();++i){
                for (String d : entryList.get(i).dataValue(data)){
                    dataList.add(d);
                }
            }
            return dataList.toArray(new String[0]);
        }
        
        public Set<String> getHeaders(){
            TreeSet<String> ret = new TreeSet<>();
            for (Entry entry : entryList){
                if (entry.header != null) ret.add(entry.header);
            }
            return ret;
        }
        public boolean isOptional(){
            return optional;
        }
        boolean optional = false;
        boolean arrayType;
        String property;   // the encode schema property
        List<Entry> entryList = new ArrayList<>();
    }
