/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet.config;

import java.util.Map;
import org.jdom2.Element;

/**
 *
 * @author gevirl
 */
public class Entry {
    public Entry(Element entryEle){
        header = entryEle.getAttributeValue("header");
        format = entryEle.getAttributeValue("format");  
        filterClass = entryEle.getAttributeValue("filter");
        if (filterClass != null){
            try {
                filter = Class.forName(filterClass);
            } catch (Exception exc){
                exc.printStackTrace();
            }
        }
        remove = entryEle.getAttributeValue("remove");
    }
    public Entry(String header,String format){
        this.header = header;
        this.format = format;
    }
    public String[] dataValue(Map<String,String> data){
            if (header==null){
                String[] ret = new String[1];
                ret[0] = format;
                return ret;
            } else {
                String dataStr = data.get(header);
                if (dataStr==null||dataStr.equals("")){
                    return new String[0];                    
                }
                String[] tokens = dataStr.split("\t|\n|,");
                String[] ret = new String[tokens.length];
                for (int i=0 ; i<tokens.length ; ++i){
                    if (remove != null){
                        tokens[i] = tokens[i].replaceAll(remove, "");
                    }
                    ret[i] = String.format(format, tokens[i]);
                }
                return ret;
            }
    }
    public void setRemove(String rem){
        this.remove = rem;
    }
    
    String remove;
    String header;     // the spreadsheet column
    String format;     // optional formating of the data - can be used to set value when no column header provided      
    String filterClass;
    Class filter = null;
}
