/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.sql.ResultSet;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.config.Column;

/**
 *
 * @author gevirl
 */
public class UniqueKeyModel extends SpreadSheetModel {
    public int next(int keyColumnIndex,int countColumnIndex,int row)throws Exception {
        Column countColumn = this.config.getColumn(countColumnIndex);
        Column keyColumn = this.config.getColumn(keyColumnIndex);
        
        CellBase base = (CellBase)this.getValueAt(row,keyColumnIndex);
        String keyValue = base.getValueAsString();

        // get the largest count from the database for the key at the given row
        String sql = String.format("Select max(%s) max from %s where %s=\'%s\'",
                countColumn.getDbColumn(),this.config.getDbTable(),keyColumn.getDbColumn(),keyValue);
        ResultSet rs = MySql.getMySql().execute(sql);
        boolean b = rs.next();
        int max = rs.getInt("max");  // returns zero if no records for the key;
        
        // also look at the keys in the spreadsheet in case there have been additions
        int n = this.getRowCount();
        for (int r=0 ; r<n ; ++r){
            if (r == row) continue;
            base = (CellBase)this.getValueAt(r,keyColumnIndex);
            String cellKey = base.getValueAsString();
            
            if (cellKey.equals("") || !cellKey.equals(keyValue)) continue;
            
            String cellCount = ((CellBase)this.getValueAt(r,countColumnIndex)).getValueAsString();
            if (cellCount.equals(""))continue;
            
            int count = Integer.valueOf(cellCount);
            if (max < count) max = count;
        }
        return max+1;
    }
}
