/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.ListCell;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
abstract public class TrackItem extends ListCell{
    public TrackItem(){
        inputs.put("Reason",null);
    }
    
    @Override
    public boolean validate(String newValue) {
        return true;
    }

    @Override
    public String getValueAsString() {
        return super.getValueAsString();
    }

    // get the tracking status and reason for given key
    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (!(source instanceof Project)){  // key is the notifying cell
            key = ((CellBase)e.getSource()).getValueAsString();
            project = (model.getLabeledCell("Project")).getValueAsString();
            loadValueFromDB(true);

        }else {  // project has changed
            if (key==null) return;
            try {
//                updateDB();
            } catch (Exception exc){
                exc.printStackTrace();
            }
            project = ((CellBase)e.getSource()).getValueAsString();
            loadValueFromDB(false);
        }
    }
    public void loadValueFromDB(boolean useDefault){
        try {
            
 //           if (!this.getValueAsString().equals("")) return;
            String table = model.config.getDbTable();
            String sql = String.format("select * from LMSTracking where DBTable=\'%s\' and Project=\'%s\' and ID=\'%s\'",table,project,key);

            ResultSet rs = MySql.getMySql().execute(sql);
            if (rs.next()){
                reason = rs.getString("Reason");
                this.setValue(rs.getString("Status"));
                this.setModified(false);
                Reason reasonCell = (Reason)inputs.get("Reason");
                reasonCell.setModified(false);                 
                
            } else { //no record in the database
                reason = "";
                // get the default value if there is one
                String def = this.getDefaultValue();
                if (def != null && useDefault) {
                    this.setValue(def);
                   
                }else {
                    this.setValue("");
                    this.setModified(false);
                    Reason reasonCell = (Reason)inputs.get("Reason");
                    reasonCell.setModified(false);                      
                }
                
            }   
             
        } catch (Exception exc){
            exc.printStackTrace();
        }
        
    }
    @Override
    public boolean updateDB()throws Exception {
        // has the reason or the tracking changed??
        Reason reasonCell = (Reason)inputs.get("Reason");
        String reasonVal = reasonCell.getValueAsString();
//        project = (model.getLabeledCell("Project")).getValueAsString();
        if (reasonCell.modified || this.modified){
            
            String table = model.config.getDbTable(); 
            String sql = String.format("select * from LMSTracking where DBTable=\'%s\' and Project=\'%s\' and ID=\'%s\'",table,project,key);
            ResultSet rs = MySql.getMySql().execute(sql);
            if (rs.next()){
                sql = String.format("update LMSTracking set Status=\'%s\',Reason=\'%s\' where DBTable=\'%s\' and Project=\'%s\' and ID=\'%s\'",
                        this.getValueAsString(),reasonVal,table,project,key);
                MySql.getMySql().execute(sql);
            }else {
                if (!this.getValueAsString().equals("")){
                    PreparedStatement state = MySql.getMySql().getStatement("Insert into LMSTracking (ID,DBTable,Project,Status,Reason) values (?,?,?,?,?)");
                    state.setString(1, key);
                    state.setString(2, table);
                    state.setString(3, project);
                    state.setString(4,this.getValueAsString());
                    state.setString(5,reasonVal);
                    state.execute();
                }
            }
            this.setModified(false); 
            reasonCell.setModified(false);
            return true;
        }
        return false;
    }
    public String getProject(){
        return this.project;
    }
    public String getReason(){
        return reason;
    }
    public void setKeyValue(String val){
        this.key = val;
    }
    public void setProject(String proj){
        this.project = proj;
    }
    public void setReason(String reas){
        this.reason = reas;
    }
    public boolean hasChanged(){
        if (super.hasChanged()) return true;
        
        CellBase reasonCell = this.inputs.get("Reason");
        if (reasonCell != null && reasonCell.hasChanged()) return true;
        
        return false;
        
    }
    String reason = null;
    String key=null;
    String project=null;
}
