/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellEditor;

/**
 *
 * @author gevirl
 */
public class TextAreaEditor extends AbstractCellEditor implements TableCellEditor{
    public TextAreaEditor(){
        button = new JButton();
        dialog = new TextAreaDialog();
        dialog.setSize(new Dimension(500,300));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setLocationRelativeTo(button);
                dialog.setVisible(true);
            }
        });        
    }
    public Object getCellEditorValue(){

        return cellObj;
    }
    
    public Component getTableCellEditorComponent(JTable table,Object value, boolean isSelected,int row, int column) {
        cellObj = (CellBase)value;
        String cellString = (String)cellObj.getValue();
        button.setText(cellString);
        dialog.setText(cellString);

        return button;
    } 
     public boolean stopCellEditing() {
        if (dialog.isAccepted()){
            String text = dialog.getText();
            cellObj.setValue(text);
        } 
        return super.stopCellEditing();
     }    
    class TextAreaDialog extends JDialog {
        public TextAreaDialog(){
            Container content = this.getContentPane();
            JPanel mainPanel = new JPanel(new BorderLayout());
            area = new JTextArea();
            area.setEditable(true);
            area.setLineWrap(true);
            mainPanel.add(area,BorderLayout.CENTER);
            
            JPanel buttonPanel = new JPanel();
            JButton accept = new JButton("Accept changes");
            accept.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    accepted = true;
                    TextAreaDialog.this.setVisible(false);
                }
            });
            
            buttonPanel.add(accept);
            JButton reject = new JButton("Discard changes");
            reject.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TextAreaDialog.this.setVisible(false);
                }
            });
            
            buttonPanel.add(reject);
            mainPanel.add(buttonPanel,BorderLayout.SOUTH);
            content.add(mainPanel);
        }
        public void setText(String text){
            accepted = false;
            area.setText(text);
        }
        public String getText(){
            return area.getText();
        }
        public boolean isAccepted(){
            return accepted;
        }
        boolean accepted;
        JTextArea area;
    }
  
    
    TextAreaDialog dialog;
    CellBase cellObj;  
    JButton button;
}
