/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.TransferHandler;

/**
 *
 * @author gevirl
 */
class SSTransferHandler extends TransferHandler
{
    protected Transferable createTransferable(JComponent comp)
    {
        if (comp instanceof JTable == false)
            return null;

        JTable table = (JTable) comp;
        int[] rows = table.getSelectedRows();
        int[] columns = table.getSelectedColumns();

        if (rows == null || columns == null)
            return null;
        if (table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()){
            int n = table.getColumnCount();
            columns = new int[n];
            for (int i=0;i<n;++i){
                columns[i] = i;
            }
        }
        if (!table.getRowSelectionAllowed() && table.getColumnSelectionAllowed()){
            int n = table.getRowCount();
            rows = new int[n];
            for (int i=0;i<n;++i){
                rows[i] = i;
            }
        }        
        RowSorter sorter = table.getRowSorter();
        for (int r=0 ; r<rows.length ; ++r){
            rows[r] = sorter.convertRowIndexToModel(rows[r]);
        }
        
        SpreadSheetModel model = (SpreadSheetModel)table.getModel();
        StringBuilder builder = new StringBuilder();
        for (int r=0;r<rows.length;++r){
            for (int c=0;c<columns.length;++c){
                CellBase base = (CellBase)model.getValueAt(rows[r], columns[c]);
                builder.append(base.getValueAsString());
                if (c < columns.length-1){
                    builder.append('\t');
                } else {
                    builder.append('\n');
                }
                
            }
        }


        return new SSTransferable(builder.toString());
    }

    public int getSourceActions(JComponent c)
    {
        return COPY;
    }

    public boolean importData(TransferHandler.TransferSupport support){
        Component comp = support.getComponent();
        if (comp instanceof JTable == false)
            return false;   
        
        JTable table = (JTable) comp;
        SpreadSheetModel model = (SpreadSheetModel)table.getModel();
        int[] rows = table.getSelectedRows();
        int[] columns = table.getSelectedColumns();
        if (rows == null || columns == null)
            return false;
        
        RowSorter sorter = table.getRowSorter();
        for (int r=0 ; r<rows.length ; ++r){
            rows[r] = sorter.convertRowIndexToModel(rows[r]);
        } 
        Transferable transferable = support.getTransferable();
        try {
            String data = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            for (int r=0 ; r<rows.length;++r){
                for (int c=0 ; c<columns.length;++c){
                    CellBase base = (CellBase)model.getValueAt(rows[r], columns[c]);
                    base.setValue(data);
                }
            }
        } catch (Exception exc){
            exc.printStackTrace();
            return false;
        }
        return true;
    }

  
}
