/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.sql.ResultSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.ListCell;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class Reason extends ListCell {
    public Reason() {
        super();
        DefaultComboBoxModel box = (DefaultComboBoxModel)this.getValue();
        box.setSelectedItem(null);
    }         
    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof Tracking){
            Tracking trackingCell = (Tracking)source;
            String nextTracking = trackingCell.getValueAsString();

            String nextProject = (model.getLabeledCell("Project")).getValueAsString();

            String table = model.config.getDbTable();
            
            // is this a new project/tracking value??
            if (nextTracking.equals(tracking) && nextProject.equals(project)) return; // not a real change - do nothing
            this.tracking = nextTracking;
            this.project = nextProject;
            
            // set up the choices for Reason from the tracking value and project
            DefaultComboBoxModel box = (DefaultComboBoxModel)this.getValue();
            box.removeAllElements();
            String sql = String.format("Select * from Reason where DBTable=\'%s\' and Project=\'%s\' and Tracking=\'%s\'"
                    ,table,project,tracking);
            try {
                ResultSet rs = MySql.getMySql().execute(sql);
                while (rs.next()){
                    String reason = rs.getString("Reason");
                    box.addElement(reason);
                }
            } catch (Exception exc){
                exc.printStackTrace();
            }
            
            // does the new tracking value have a reason already??
            String reason = trackingCell.getReason();
            if (reason!=null && !reason.equals("")){
                this.setValue(reason);
            } else {
                this.setValue(null);
            }
        }
    }

    @Override
    public boolean validate(String newValue) {
        return true;
    }
    String project;
    String tracking;
}
