/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.spreadsheet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.freixas.jcalendar.JCalendar;

/**
 *
 * @author gevirl
 */
public class CalendarEditor extends AbstractCellEditor implements TableCellEditor{
    public CalendarEditor(){
        button = new JButton();
        dialog = new CalendarEditor.CalendarDialog();
        dialog.setSize(new Dimension(500,300));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setLocationRelativeTo(button);
                dialog.setVisible(true);
            }
        });        
    }
    
    public Component getTableCellEditorComponent(JTable table,Object value, boolean isSelected,int row, int column) {
        cellObj = (CellBase)value;
        Date date = (Date)cellObj.getValue();
        String dateStr = cellObj.getAsSqlString();
        
        button.setText(dateStr);
        dialog.setDate(date);

        return button;        
    } 
    
     public Object getCellEditorValue() {
       cellObj.unlock();
        return cellObj;
    }

     public boolean stopCellEditing() {
         return super.stopCellEditing();
     }
    class CalendarDialog extends JDialog {
        public CalendarDialog(){
            Container content = this.getContentPane();
            JPanel mainPanel = new JPanel(new BorderLayout());
            calendar = new JCalendar();
            mainPanel.add(calendar,BorderLayout.CENTER);
            
            JPanel buttonPanel = new JPanel();
            JButton accept = new JButton("OK");
            accept.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    accepted = true;
                    CalendarEditor.CalendarDialog.this.setVisible(false);
                    cellObj.setValue(dialog.getDate());
                    String dateStr = cellObj.getValueAsString();
                    button.setText(dateStr);
                }
            });
            
            buttonPanel.add(accept);
            JButton reject = new JButton("Cancel");
            reject.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CalendarEditor.CalendarDialog.this.setVisible(false);
                }
            });
            
            buttonPanel.add(reject);
            mainPanel.add(buttonPanel,BorderLayout.SOUTH);
            content.add(mainPanel);
        }
        public void setDate(Date date){
            accepted = false;
            calendar.setDate(date);
        }
        public Date getDate(){
            return calendar.getDate();
        }
        public boolean isAccepted(){
            return accepted;
        }
        JCalendar calendar;
        boolean accepted;
        
    }    
    CalendarDialog dialog;
     JButton button;
     
     CellBase cellObj;
     JTextField field;
     JComboBox box;
     DefaultComboBoxModel boxModel;
     
     String initialValue;
}
