/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.wormRNA;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.models.FreezeModel;
import org.rhwlab.LMS.models.WormRNASampleModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */

public class SampleNumber extends IntegerCell {
    public SampleNumber(){
        this("");
    }
    public SampleNumber(String id){
        super(id);
        inputs.put("StrainID",null);
        inputs.put("Stage",null);
    }    
    
    @Override
    public void stateChanged(ChangeEvent ce) {
        // get the transcript
        CellBase base = (CellBase)inputs.get("StrainID");
        if (base == null)return;
        String strain = base.getValueAsString();
        if (strain.equals("")) return;
        
        base = (CellBase)inputs.get("Stage");
        if (base == null) return;
        String stage = base.getValueAsString();
        if (strain.equals("")) return;        
        
        // get the next design value
        WormRNASampleModel sampleModel = (WormRNASampleModel)this.getModel();
        int sample = 0;
        try {
            sample = sampleModel.nextSample(strain,stage,this.getRow());
        }catch(Exception exc){exc.printStackTrace();}
        
        this.setValue(Integer.toString(sample));
        this.unlock();
        
        
    }    
}