/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.wormRNA;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.DCCResponse;
import org.rhwlab.LMS.StringListCell;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.HasList;

/**
 *
 * @author gevirl
 */
public class DataSetFileList extends StringListCell implements HasList {
    // notified of the DataSet
    public void stateChanged(ChangeEvent ce) {
        String dataSet = ((CellBase)ce.getSource()).getValueAsString();
        ArrayList<String> fileAccList = new ArrayList<>();

        try {
            addFileAccessions("RNASequencing","DataSetID",fileAccList,dataSet);
            addFileAccessions("RNASeqAlignment","DataSet",fileAccList,dataSet);
            addFileAccessions("RNAExpression","DataSetID",fileAccList,dataSet);
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String acc : fileAccList){
                if (!first){
                    builder.append("\t");
                }
                builder.append(acc);
                first = false;
            }
            this.setValue(fileAccList);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        
    }
    public void addFileAccessions(String table,String column,List<String> accessions,String dataSet){
        String sql = String.format("select ResponseJson from %s where %s = \'%s\' ", table,column,dataSet);
        try {
            ResultSet rs = MySql.getMySql().execute(sql);
            while(rs.next()){
                String response = rs.getString("ResponseJson");
                if (response != null){
                    DCCResponse responseCell = new DCCResponse();
                    responseCell.setValue(response);
                    List<String> fileAccs = responseCell.getAccessions("file");
                    accessions.addAll(fileAccs);
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }   
        if (dataSet.startsWith("MT")){
            int aishdf=0;
        }
    }

    @Override
    public List getList() {
        return (List)this.getValue();
    }
}
