/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.wormRNA;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.DCCResponse;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.encode.CollectionUrl;
import org.rhwlab.encode.EncodeUrl;
import org.rhwlab.spreadsheet.HasUrl;
import org.rhwlab.spreadsheet.config.JsonConfig;
import org.rhwlab.spreadsheet.config.SpreadSheet;

/**
 *
 * @author gevirl
 */
public class Accession extends TextCell implements HasUrl {
    public Accession(){
        inputs.put("Species", null);
    }
    static String server  = "www.encodeproject.org" ;


    @Override
    public String getUrl() {
        String species = inputs.get("Species").getValueAsString();
        String acc = this.getValueAsString();
        if (acc.startsWith("ENCFF")){
            return new  CollectionUrl(server,"files").getUrl()+"/"+acc;
        }
        else if (acc.startsWith("ENCLB")){
            return new  CollectionUrl(server,"libraries").getUrl()+"/"+acc;
        }
        else if (acc.startsWith("ENCSR")){
            return new  CollectionUrl(server,"experiments").getUrl()+"/"+acc;
        }    
        else if (acc.startsWith("ENCBS")){
            return new  CollectionUrl(server,"biosamples").getUrl()+"/"+acc;
        } 
        else if (acc.startsWith("ENCDO")&&species.equals("celegans")){
            return new  CollectionUrl(server,"worm-donors").getUrl()+"/"+acc;
        }        
        else if (acc.startsWith("ENCDO")&&species.contains("dmel")){
            return new  CollectionUrl(server,"fly-donors").getUrl()+"/"+acc;
        }        
        return "";
    }
}
