/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;
import org.rhwlab.spreadsheet.config.SpreadSheet;
import org.rhwlab.spreadsheet.config.Transfer;

/**
 *
 * @author gevirl
 */
public class TransferMenuItem extends JMenuItem{

   
    public TransferMenuItem(String label,final String transfer,final SpreadSheetPanel sourcePanel){     
        this(label,toArray(transfer),sourcePanel);
    }
    public TransferMenuItem(String label,final String[] transfers,final SpreadSheetPanel sourcePanel){
        this.setText(label);
        addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    performAction(transfers,sourcePanel);
                } catch(Exception exc){
                    exc.printStackTrace();
                }

            }
        });        
    }    
    // performs the action of this menu item    
    public void performAction(final String[] transfers,final SpreadSheetPanel sourcePanel)throws Exception {
       
        SpreadSheet sheet = sourcePanel.getConfig();
        if (checkAllTransfers(transfers,sheet,sourcePanel)){
            ArrayList<String> confirmed = confirm(transfers,sheet,sourcePanel);  // a list of confirmed(by user)  transfers
            if (!confirmed.isEmpty()){
                // make the transfers only if all are confirmed and valid
                for (String transferName : confirmed){
                    Transfer transfer = sheet.getTransfer(transferName);
                    String destClass = transfer.getPanelClass();
                    SpreadSheetPanel dest = sheet.getPanel(destClass);
                    Object repeat = transfer.getRepeat();
                    LinkedHashMap<String,String> pairsMap = transfer.getPairings();
                    int[] destRows = sourcePanel.addSelectedToMappedPanel(dest,pairsMap,repeat,transfer.getRequiredColumns());
                    dest.setSelectedRows(destRows);
                }
                // notify listeners that transfers completed
                for (ActionListener listen : listeners){
                    listen.actionPerformed(null);
                }            
            } 
        }
    }

    // check the transfers can be made (check any columns that are configured to be checked for duplication)
    // returns true if the transfers are okay (no duplications)
    private boolean checkAllTransfers(String[] transfers,SpreadSheet sheet,SpreadSheetPanel sourcePanel)throws Exception {
        for (String transfer : transfers){
            if (!checkTransfer(transfer,sheet,sourcePanel)){
                return false;  // returns false if any of the transfers returns false;
            }
        }
        return true;
    }  
    // check that a single transfer can be made
    // true mesans the transfer can be made
    private boolean checkTransfer(String transferName,SpreadSheet sheet,SpreadSheetPanel sourcePanel)throws Exception {
        Transfer transfer = sheet.getTransfer(transferName);
        String destClass = transfer.getPanelClass();
        SpreadSheetPanel destPanel = sheet.getPanel(destClass);
        SpreadSheetModel destModel = destPanel.getModel();
        int[] ret = sourcePanel.getConvertedSelectedRows();
        for (int r : ret){
            if (!checkRowTransfer(r,transfer,destModel,sourcePanel)){
                return false;
            }
        }
        return true;
    }
    // check that a given row of a transfer can be made
    // true means the transfer is okay (no dups)
    private boolean checkRowTransfer(int row,Transfer transfer,SpreadSheetModel destModel,SpreadSheetPanel sourcePanel) throws Exception {
        // are there configured checks to be performed
        HashMap<String,String> pairings = transfer.getCheckedPairings();
        for (String sourceColumn : pairings.keySet()){
            String destColumn  = pairings.get(sourceColumn);
            // get the source value
            String sourceValue = sourcePanel.getValue(row, sourceColumn);
            if (destModel.checkValue(destColumn, sourceValue)) {
                // warn the user
                String destTitle = destModel.getConfig().getTitle();
                String warning = String.format("Duplicate value = %s for %s in %s", sourceValue,destColumn,destTitle);
                int res = JOptionPane.showOptionDialog(LabMan.labMan,warning,"Potential Duplication",JOptionPane.YES_NO_OPTION
                        ,JOptionPane.WARNING_MESSAGE, null,warnOptions,null);
                if (res !=0) return false;
            }

        }
        for (String sourceColumn : transfer.getRequiredColumns()){
            String sourceValue = sourcePanel.getValue(row, sourceColumn);
            if (sourceValue==null || sourceValue.equals("")){
                String msg = String.format("%s is required for transfer",sourceColumn);
                JOptionPane.showMessageDialog(LabMan.labMan, msg);
                return false;
            }            
        }
        return true;
    }
    // confirm all the transfers with the user
    private ArrayList<String>  confirm(String[] transfers,SpreadSheet sheet,SpreadSheetPanel sourcePanel){
        HashMap<String,Integer> counts = new HashMap<String,Integer>();
        ArrayList<String> nonZero = new ArrayList<String>();
        for (String transferName : transfers){
            Transfer transfer = sheet.getTransfer(transferName);
            String[] required = transfer.getRequiredColumns();
            String panelClass = transfer.getPanelClass();
            SpreadSheetPanel panel = sheet.getPanel(panelClass);
            if (panel == null){
                JOptionPane.showMessageDialog(LabMan.labMan, "Missing the destination view for transfer to "+transferName);
                return nonZero;
            }
            int[] ret = sourcePanel.getConvertedSelectedRows();
            // count the tranferable record
            Integer count = counts.get(panelClass);
            if (count == null){
                count = new Integer(0);
                counts.put(panelClass, count);
            }            
            int n=0;
            for (int row : ret){
                if (sourcePanel.getModel().hasData(row, required)){
                    ++n;
                    Object repeat = transfer.getRepeat();
                    if (repeat instanceof String){
                        count = new Integer(count.intValue() + new Integer (sourcePanel.getValue(row,(String)repeat )));
                    }else {
                        count = new Integer(count.intValue() + (Integer)repeat);
                    }
                }
            }
            if (n > 0){
                nonZero.add(transferName);
            }
            counts.put(panelClass, count);
        }
        
        
        StringBuilder build = new StringBuilder();
        build.append("You are adding\n");
        for (String panelClass : counts.keySet()){
            Integer count = counts.get(panelClass);
            SpreadSheetPanel panel = sheet.getPanel(panelClass);
            build.append(String.format("%d record(s) to the %s table\n",count,panel.getModel().getViewTitle()));
        }
        
        if (JOptionPane.showOptionDialog(LabMan.labMan,build.toString(),"Adding Record(s) to a Table",JOptionPane.YES_NO_OPTION,
                    JOptionPane.WARNING_MESSAGE, null,options,null) == 0 ){
            return nonZero;
        }else {
            nonZero.clear();
            return nonZero;
        }
    
    }
    private static String[] toArray(String s){
        String[] ret = new String[1];
        ret[0] = s;
        return ret;
    }
    public void addListener(ActionListener listen){
        listeners.add(listen);
    }
    ArrayList<ActionListener> listeners = new ArrayList<ActionListener>();
    static String[] options = {"Add Record(s)","Cancel"}; 
    static String[] warnOptions = {"Continue transfer","Cancel Transfers"};
}
