/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.TreeSet;
import javax.swing.JMenuItem;
import org.rhwlab.DAG.views.GeneTablePanel;
import org.rhwlab.DAG.views.UnifiedResultFrame;
import org.rhwlab.LMS.RNASeq.TimeSeriesMap;
import org.rhwlab.LMS.RNASeq.TimeWarpID;
import static org.rhwlab.LMS.views.UnificationPanel.inits;
import static org.rhwlab.LMS.views.UnificationPanel.viewItem;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
 
public class TimeWarpPanel extends TrackingPanel implements ActionListener {

    public TimeWarpPanel() {
        super(false, inits);
        buildMenu();

    }

    public void buildMenu() {

        super.getMenu();
        menu.setText("TimeWarp"); 
        
        JMenuItem warp = new JMenuItem(timewarp);
        warp.addActionListener(this);
        menu.add(warp);         
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
        int[] rows = this.getConvertedSelectedRows();
        if (e.getActionCommand().equals(timewarp)) {

            int timeWarpColumn = this.getConfig().getColumn("TimeWarpID");
            for (int i = 0; i < rows.length; ++i) {
                TimeWarpID id = (TimeWarpID) this.getModel().getValueAt(rows[i], timeWarpColumn);

                    id.submit();
                    this.updateDB();
                    Thread.sleep(500);  

            }

        }
            else if (e.getActionCommand().equals(viewItem)) {

                int timeSeriesColumn = this.getConfig().getColumn("TimeSeries");
                TimeSeriesMap map = (TimeSeriesMap) this.getModel().getValueAt(rows[0], timeSeriesColumn);
                UnifiedResultFrame frame = new UnifiedResultFrame();
                frame.setStudies(map.getStudy());
                GeneTablePanel panel = new GeneTablePanel();
                // build a gene list
                TreeSet<String> geneList = new TreeSet<>();
                File uniDir = new File(map.getDirectory());
                String[] uniFiles = uniDir.list();
                for (String uniFile : uniFiles){
                    if (uniFile.startsWith("Genes.")){
                        File uni= new File(uniDir,uniFile);
                        BufferedReader reader = new BufferedReader(new FileReader(uni));
                        String line = reader.readLine();
                        while(line != null){
                            geneList.add(line);
                            line = reader.readLine();
                        }
                        reader.close();
                    }
                }
                panel.setGeneList(geneList);
                panel.init();
                frame.setGeneTable(panel);
                frame.init();
                frame.setVisible(true);
            } 
        } catch (Exception exc){
             exc.printStackTrace();
        }
    }
    static String timewarp = "Submit Time Warping";
}
