/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.rhwlab.LMS.models.RescueModel;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class RescuePanel extends TrackingPanel{
    public RescuePanel(){
        super(false,inits);
        buildMenu();
    }
   
    private void buildMenu() {
        JMenu menu = super.getMenu();
        menu.setText("Rescues");        
        
        final TransferMenuItem addScreen = new TransferMenuItem("To Integration","Integration",RescuePanel.this);
        addScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int[] sel = RescuePanel.this.getConvertedSelectedRows();
                SpreadSheetModel model = RescuePanel.this.getModel();
                int col = model.findColumn("ToIntegration");
                Date date = new Date();
                for (int i=0 ; i<sel.length ; ++i){
                    CellBase base = (CellBase)model.getValueAt(sel[i], col);
                    base.setValue(date);
                }
            }
        });
        menu.add(addScreen);  
        
        JMenuItem pcr = new TransferMenuItem("To PCR","PCR",RescuePanel.this);
        menu.add(pcr);           
        
        JMenuItem archive = new JMenuItem("Mark Selected as Complete");
        archive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int[] sel = RescuePanel.this.getConvertedSelectedRows();
                RescueModel model = (RescueModel)RescuePanel.this.getModel();
                int col = model.findColumn("Tracking");
                for (int i=0 ; i<sel.length ; ++i){
                    CellBase base = (CellBase)model.getValueAt(sel[i], col);
                    base.setValue("Complete");
                }
            }
        });
        menu.add(archive);
        
        JMenu filter = new JMenu("Other Filters");

        
        nonzero = new JCheckBoxMenuItem("Nonzero %");
        nonzero.setSelected(false);
        nonzero.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    loadSpecialFromDB();
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        filter.add(nonzero); 

        percent = new JCheckBoxMenuItem("100 %");
        percent.setSelected(false);
        percent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    loadSpecialFromDB();
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        filter.add(percent);     
        

        ButtonGroup group = new ButtonGroup();
        group.add(nonzero);
        group.add(percent);;
        menu.add(filter);
    }
    public void loadSpecialFromDB()throws Exception {
        if (nonzero!=null && nonzero.isSelected()){
            String sql = "Select * from Rescue where FirstIntegration>0 or SecondIntegration>0";
            loadModelFromDB(sql);
        }  else if (percent!=null && percent.isSelected()){
            String sql = "Select * from Rescue where FirstIntegration=100 or SecondIntegration=100";
            loadModelFromDB(sql);
        }
    }
    static String[] inits = {"Pending"};
    JCheckBoxMenuItem nonzero;
    JCheckBoxMenuItem percent;
}
