/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views.RNASeq;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import org.rhwlab.LMS.RNASeq.singlecell.Demultiplexer;
import org.rhwlab.LMS.RNASeq.singlecell.WellID;
import org.rhwlab.LMS.views.TransferMenuItem;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class SingleCellWellPanel extends TrackingPanel implements ActionListener {
    public SingleCellWellPanel(){
        super(false, inits);
        buildMenu();        
    }
    public void buildMenu() {
        
        super.getMenu();
        menu.setText("SingleCellWells");   
        
        JMenuItem demux = new JMenuItem(filter);
        demux.addActionListener(this);
        menu.add(demux); 
        
        JMenuItem alignItem = new TransferMenuItem("To Alignments","Alignment",SingleCellWellPanel.this);
        menu.add(alignItem);         
    } 

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] rows = this.getConvertedSelectedRows();
        if (rows.length == 0) return;
        

       try {        
            for (int i=0 ; i<rows.length ; ++i){
                String welID = this.getValue(rows[i],"WellID");
                String fastq = this.getValue(rows[i],"Fastq");
                Demultiplexer.filterByMolecularBarcode(fastq, welID);
            }
        } catch (Exception exc){
            exc.printStackTrace();
        }
    }
    public WellID[] findWells(String expID){
        ArrayList<WellID> list = new ArrayList<>();
        SpreadSheetModel model = this.getModel();
        int wellCol = this.getConfig().getColumn("WellID");
        for (int r=0 ; r<model.getRowCount() ; ++r){
            WellID ret = (WellID)model.getValueAt(r, wellCol);
            String retString = ret.getValueAsString();
            if (retString.startsWith(expID)){
                list.add(ret);
            }
        }
        return list.toArray(new WellID[0]);
    }
    static String[] inits = {"Pending"};
    static String filter = "Filter by Molecular Barcode";
}
