/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views.RNASeq;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.math.BigDecimal;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.RNASeq.singlecell.Demultiplexer;
import org.rhwlab.LMS.RNASeq.singlecell.Experiment;
import org.rhwlab.LMS.RNASeq.singlecell.PoolID;
import org.rhwlab.LMS.RNASeq.singlecell.WellID;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class SingleCellPoolPanel extends TrackingPanel implements ActionListener {
     public SingleCellPoolPanel(){
        super(false, inits);
        buildMenu();        
    }
    public void buildMenu() {
        
        super.getMenu();
        menu.setText("SingleCellWells");   
        
        JMenuItem demux = new JMenuItem(demuxCmd);
        demux.addActionListener(this);
        menu.add(demux); 
    } 

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] rows = this.getConvertedSelectedRows();
        if (rows.length == 0) return;
        
        SingleCellWellPanel wellPanel = (SingleCellWellPanel)this.getConfig().getPanel("org.rhwlab.LMS.views.RNASeq.SingleCellWellPanel");
        int poolCol = this.getConfig().getColumn("PoolID");
        try {
            for (int i=0 ; i<rows.length ; ++i){
                String pool = this.getValue(rows[i],"PoolID");
                PoolID poolCell = (PoolID)this.getModel().getValueAt(rows[i],poolCol);
                JsonObjectBuilder poolBuilder = poolCell.toJsonBuilder();

                JsonArrayBuilder wellsBuilder = Json.createArrayBuilder();
                String[] experiments = Experiment.getPoolExperiments(pool);
                for (String experiment : experiments){
                    WellID[] wells = wellPanel.findWells(experiment);
                    for (WellID well : wells){
                        wellsBuilder.add(well.toJsonBuilder());
                    }
                }
                poolBuilder.add("Wells",wellsBuilder);

                JsonWriter writer = Json.createWriter(new FileWriter(String.format("/nfs/waterston/LabMan/json/%s",pool)));
                JsonObject demuxObj = poolBuilder.build();
                writer.writeObject(demuxObj);
                writer.close();

                Demultiplexer demux = new Demultiplexer(demuxObj);
                demux.init();
                demux.run();
            }
        } catch (Exception exc){
            exc.printStackTrace();
        }
        
    }

    static String[] inits = {"Pending"};
    static String demuxCmd = "Submit Demultiplexing ";    
}
