/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.views.RNASeq;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.RNASeq.AWS;
import org.rhwlab.LMS.RNASeq.Finisher;
import org.rhwlab.LMS.RNASeq.md5.BAMFile;
import org.rhwlab.LMS.RNASeq.merged.ExonSummary;
import org.rhwlab.LMS.RNASeq.merged.MergedID;
import org.rhwlab.LMS.RNASeq.views.MatrixDisplayFrame;
import org.rhwlab.LMS.views.TransferMenuItem;
import org.rhwlab.spreadsheet.SpreadSheetModel;
import org.rhwlab.spreadsheet.SpreadSheetPanel;
import org.rhwlab.spreadsheet.TrackingPanel;

/**
 *
 * @author gevirl
 */
public class MergedBamPanel extends TrackingPanel implements ActionListener {

    public MergedBamPanel() {
        super(true, inits);
        buildMenu();
    }

    public void buildMenu() {

        super.getMenu();
        menu.setText("MergedBAM");
        /*        
        JMenuItem align = new JMenuItem(submitMerge);
        align.addActionListener(this);
        menu.add(align); 
         */
        TransferMenuItem copyItem = new TransferMenuItem(copyMerge, "MergedBAM", this);
        /*        
        copyItem.addListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                
                int[] rows = MergedBamPanel.this.getConvertedSelectedRows();
                if (rows.length==0 )return;
                    for (int i=0 ; i<rows.length ;++i){
                        int mergeColumn = MergedBamPanel.this.getConfig().getColumn("MergedID");
                        MergedID mergeID = (MergedID)MergedBamPanel.this.getModel().getValueAt(rows[i],mergeColumn);
                        try {
                            MergedBamPanel.this.updateDB();
                            mergeID.submitMerge();
                            MergedBamPanel.this.updateDB();
                            Thread.sleep(1000);
                        }catch (Exception exc){
                            exc.printStackTrace();
                        }
                    }                 
                }
            });
         */
        menu.add(copyItem);
        /*        
        JMenuItem dupCalc = new JMenuItem(submitDupCalc);
        dupCalc.addActionListener(this);
        menu.add(dupCalc);     
        
        JMenuItem dupRemove = new JMenuItem(submitRemoveDups);
        dupRemove.addActionListener(this);
        menu.add(dupRemove);
         */
        JMenuItem expItem = new TransferMenuItem(express, "Expression", this);
        menu.add(expItem);

        /*        
        JMenuItem countRNA = new JMenuItem(rRNAReads);
        countRNA.addActionListener(this);
        menu.add(countRNA);

        JMenuItem combined = new JMenuItem(combinedItem);
        combined.addActionListener(this);
        menu.add(combined);
        
        JMenuItem exp = new TransferMenuItem(individualItem,"Expression",this);
        menu.add(exp);   
        

 //       JMenuItem ref = new JMenuItem(refCount);
 //       ref.addActionListener(this);
 //       menu.add(ref);

        JMenu removeMenu = new JMenu(remove);      
        JMenuItem rRNAItem = new JMenuItem(removeRNA);
        rRNAItem.addActionListener(this);
        removeMenu.add(rRNAItem);
        JMenuItem histoneItem = new JMenuItem(removeHistones);
        histoneItem.addActionListener(this);
        removeMenu.add(histoneItem);
        menu.add(removeMenu);
        
        JMenuItem anno = new JMenuItem(annotate);
        anno.addActionListener(this);
        menu.add(anno); 
         */
        JMenuItem exonItem = new JMenuItem(exonCount);
        exonItem.addActionListener(this);
        menu.add(exonItem);

        JMenuItem wigItem = new JMenuItem(bigWig);
        wigItem.addActionListener(this);
        menu.add(wigItem);

        JMenuItem fin = new JMenuItem(finish);
        fin.addActionListener(this);
        menu.add(fin);

        JMenuItem remfin = new JMenuItem(removefinish);
        remfin.addActionListener(this);
        menu.add(remfin);
        /*    
        JMenuItem dccFileUpload = new JMenuItem(upload);
        dccFileUpload.addActionListener(this);
        menu.add(dccFileUpload);       
         */

    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] rows = this.getConvertedSelectedRows();
        if (rows.length == 0) {
            return;
        } /*        
        if (e.getActionCommand().equals(submitMerge)){
            for (int i=0 ; i<rows.length ;++i){
                int mergeColumn = this.getConfig().getColumn("MergedID");
                MergedID mergeID = (MergedID)this.getModel().getValueAt(rows[i],mergeColumn);
                try {
                    this.updateDB();
                    mergeID.submitMerge();
                    this.updateDB();
                    Thread.sleep(1000);
                }catch (Exception exc){
                    exc.printStackTrace();
                }
            }            
        }
   
        if (e.getActionCommand().equals(submitDupCalc)){
            // make sure all the merges have been done
            ArrayList<String> notDone = new ArrayList<>();
            for (int i=0 ; i<rows.length ;++i){
                String completed = this.getValue(rows[i], "MergeCompleted");
                String mergeID = this.getValue(rows[i], "MergedID");
                if (completed.equals("")){
                    notDone.add(mergeID);
                }
            }
            if (notDone.isEmpty()){
                for (int i=0 ; i<rows.length ;++i){
                    int mergeColumn = this.getConfig().getColumn("MergedID");
                    MergedID mergeID = (MergedID)this.getModel().getValueAt(rows[i],mergeColumn);
                    try {
                        this.updateDB();
                        mergeID.submitDupRateCalc();
                        this.updateDB();
                        Thread.sleep(1000);
                    }catch (Exception exc){
                        exc.printStackTrace();
                    }
                }
            }  
            else {
                StringBuilder builder = new StringBuilder();
                for (String mergeID : notDone){
                    builder.append(mergeID+"\n");
                }
                String msg = String.format("These merges have not completed:\n%s",builder.toString());
                JOptionPane.showMessageDialog(LabMan.labMan, msg);
            }          
        }    
        if (e.getActionCommand().equals(submitRemoveDups)){
            // make sure all the dup rates calculated have been done
            ArrayList<String> notDone = new ArrayList<>();
            for (int i=0 ; i<rows.length ;++i){
                String completed = this.getValue(rows[i], "PCRDupRate");
                String mergeID = this.getValue(rows[i], "MergedID");
                if (completed.equals("")){
                    notDone.add(mergeID);
                }
            }  
            if (notDone.isEmpty()){
                for (int i=0 ; i<rows.length ;++i){
                    int mergeColumn = this.getConfig().getColumn("MergedID");
                    MergedID mergeID = (MergedID)this.getModel().getValueAt(rows[i],mergeColumn);
                    try {
                        this.updateDB();
                        mergeID.submitDupRemoval();
                        this.updateDB();
                        Thread.sleep(1000);
                    }catch (Exception exc){
                        exc.printStackTrace();
                    }
                } 
            }
            else {
                StringBuilder builder = new StringBuilder();
                for (String mergeID : notDone){
                    builder.append(mergeID+"\n");
                }
                String msg = String.format("PCR dup rate not calculated for:\n%s",builder.toString());
                JOptionPane.showMessageDialog(LabMan.labMan, msg);
            }            
        }  
         */ else if (e.getActionCommand().equals(rRNAReads)) {
            int fileColumn = this.getConfig().getColumn("BAM");
            for (int i = 0; i < rows.length; ++i) {
                BAMFile bamFile = (BAMFile) this.getModel().getValueAt(rows[i], fileColumn);
                try {
                    this.updateDB();
                    bamFile.submitRibosomalCounts();

                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        } else if (e.getActionCommand().equals(combinedItem)) {
            SpreadSheetPanel expPanel = this.getConfig().getPanel(this.getConfig().getTransfer("Expression").getPanelClass());
            SpreadSheetModel expModel = expPanel.getModel();

            // check all the rows have the same library and reference
            String libId = this.getValue(rows[0], "LibraryID");
            String ref = this.getValue(rows[0], "Reference");
            String user = this.getValue(rows[0], "UserName");
            String dataset = this.getValue(rows[0], "DataSet");
            for (int i = 1; i < rows.length; ++i) {
                if (!libId.equals(this.getValue(rows[i], "LibraryID")) || !ref.equals(this.getValue(rows[i], "Reference"))) {
                    JOptionPane.showMessageDialog(this, "All LibraryIDs and References must be the same to combine alignments");
                    return;
                }
            }

            // gather all the AlignmentIDs into a json array
            JsonArrayBuilder alignBuilder = Json.createArrayBuilder();
            for (int i = 0; i < rows.length; ++i) {
                alignBuilder.add(this.getValue(rows[i], "AlignmentID"));
            }

            // add a new row to the expression table
            int expRow = expModel.addEmptyRow();
            expPanel.moveToRow(expRow);
            expModel.setValue(expRow, "LibraryID", libId, true);
            expModel.setValue(expRow, "UserName", user, true);
            expModel.setValue(expRow, "Reference", ref, true);
            expModel.setValue(expRow, "DataSet", dataset, true);
            expModel.setValue(expRow, "AlignmentIDs", alignBuilder.build(), true);

        } else if (e.getActionCommand().equals(refCount)) {
            int fileColumn = this.getConfig().getColumn("BAM");
            TreeMap<String, double[]> countMap = new TreeMap<>();
            String[] columnNames = new String[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                try {
                    String id = this.getValue(rows[i], "AlignmentID");
                    columnNames[i] = id;
                    BAMFile bamFile = (BAMFile) this.getModel().getValueAt(rows[i], fileColumn);
                    TreeMap<String, Double> counts = bamFile.referenceCounts();
                    for (String ref : counts.keySet()) {
                        double[] data = countMap.get(ref);
                        if (data == null) {
                            data = new double[rows.length];
                            for (int j = 0; j < data.length; ++j) {
                                data[j] = 0.0;
                            }
                            countMap.put(ref, data);
                        }
                        data[i] = counts.get(ref);
                    }

                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            MatrixDisplayFrame frame = new MatrixDisplayFrame();
            frame.addTab(columnNames, countMap, "Reference Counts");
            frame.setVisible(true);
        } else if (e.getActionCommand().equals(finish)) {
            for (int i = 0; i < rows.length; ++i) {
                try {
                    String id = this.getValue(rows[i], "MergedID");
                    Finisher finisher = new Finisher(id, "MergeBAMs");
                    finisher.run();
                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        } else if (e.getActionCommand().equals(bigWig)) {
            for (int i = 0; i < rows.length; ++i) {
                try {
                    int idColumn = this.getConfig().getColumn("MergedID");
                    MergedID id = (MergedID) this.getModel().getValueAt(rows[i], idColumn);
                    id.buildBigWig();
                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        } else if (e.getActionCommand().equals(exonCount)) {
            try {
                String[] sampleIDs = new String[rows.length];
                File[] files = new File[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    sampleIDs[i] = this.getValue(rows[i], "MergedID");
                    String dir = this.getValue(rows[i], "Directory");
                    files[i] = new File(dir, "Aligned.toGenome.out.name.sorted.WS260.exonic.exon.csv");
                }
                String[] idCols = {"ExonID","WBGene","SequenceName","GeneName","Chromosome","Start","End","Length"};
                ExonSummary summary = new ExonSummary(files, sampleIDs,idCols,"TPM");
                summary.averageFACSReps(7);
                JFileChooser chooser = new JFileChooser();
                if (chooser.showSaveDialog(this)==JFileChooser.APPROVE_OPTION){
                    summary.saveTo(chooser.getSelectedFile());
                }
            } catch (Exception exc) {
                exc.printStackTrace();
            }
        } else if (e.getActionCommand().equals(removefinish)) {
            for (int i = 0; i < rows.length; ++i) {
                try {
                    String id = this.getValue(rows[i], "MergedID");
                    Finisher finisher = new Finisher(id, "RemoveDup");
                    finisher.run();
                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        if (e.getActionCommand().equals(annotate)) {
            for (int i = 0; i < rows.length; ++i) {
                int bamColumn = this.getConfig().getColumn("BAM");
                BAMFile bam = (BAMFile) this.getModel().getValueAt(rows[i], bamColumn);
                try {
                    bam.submitSLAnnotation();
                    Thread.sleep(3000);
                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        } else if (e.getActionCommand().equals(upload)) {
            String server = this.getConfig().getJsonConfig("file").getServer();
            for (int i = 0; i < rows.length; ++i) {
                int idColumn = this.getConfig().getColumn("DCCResponse");
                AWS id = (AWS) this.getModel().getValueAt(rows[i], idColumn);
                try {
                    id.submitAlignment(server);
                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        } else if (e.getActionCommand().equals(removeRNA) || e.getActionCommand().equals(removeHistones)) {
            for (int i = 0; i < rows.length; ++i) {
                String id = this.getValue(rows[i], "AlignmentID");
                String directory = this.getValue(rows[i], "Directory");
                File file = new File(directory, "Aligned.toTranscriptome.out.bam");
                org.rhwlab.alignment.BAM bamFile = new org.rhwlab.alignment.BAM(file);
                try {
                    if (e.getActionCommand().equals(removeRNA)) {
                        //                   bamFile.removeRibosomal();
                    } else {
//                    bamFile.removeHistones();
                    }
                    Finisher.updateMD5sums(directory, "RNASeqAlignment", "AlignmentID", id);
                } catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }

    }
    static String[] inits = {"Pending"};

    static String copyMerge = "Copy Selected Merges";
    static String submitMerge = "Submit the Merge";
    static String submitDupCalc = "Submit Dup Rate Calculation";
    static String submitRemoveDups = "Submit PCR Dup Removal";
    static String express = "To Expression";

    static String finish = "Run Merge Finisher";
    static String removefinish = "Run RemoveDups Finisher";
    static String combinedItem = "Combined Alignments(BAMs) for Expression";
    static String individualItem = "Individual Alignments(BAMs) for Expression";
    static String refCount = "Table of Reference Counts";
    static String annotate = "Submit for SL annotation of BAM";
    static String upload = "Upload BAM to the DCC";
    static String remove = "Remove Alignments from BAM";
    static String removeRNA = "Ribosomal RNA";
    static String removeHistones = "Histones";
    static String rRNAReads = "Submit to Count rRNA Reads";
    static String bigWig = "Form bigWig";
    static String exonCount = "Report Exon Counts";
}
